/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.generation.files;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.java.generation.files.AbstractAcceleoGenerator;
import org.eclipse.modisco.java.generation.files.JavaModel2JavaTextSwitch;

public class GenerateJava
extends AbstractAcceleoGenerator {
    @Deprecated
    public static final String MODULE_FILE_NAME = "/org/eclipse/modisco/java/generation/files/GenerateJava";
    @Deprecated
    public static final String[] TEMPLATE_NAMES = new String[]{"write"};

    public GenerateJava() {
    }

    public GenerateJava(URI modelURI, File targetFolder, List<? extends Object> arguments) throws IOException {
        this.initialize(modelURI, targetFolder, (List)arguments);
    }

    public GenerateJava(EObject model, File targetFolder, List<? extends Object> arguments) throws IOException {
        this.initialize(model, targetFolder, (List)arguments);
    }

    public static void main(String[] args) {
        try {
            if (args.length < 2) {
                System.out.println("Arguments not valid : {model, folder}.");
            } else {
                URI modelURI = URI.createFileURI((String)args[0]);
                File folder = new File(args[1]);
                ArrayList arguments = new ArrayList();
                GenerateJava generator = new GenerateJava(modelURI, folder, arguments);
                generator.doGenerate((Monitor)new BasicMonitor());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void doGenerate(Monitor monitor) throws IOException {
        List<Resource> resources = Collections.singletonList(this.modelResource);
        JavaModel2JavaTextSwitch javaModel2javaTextSwitch = new JavaModel2JavaTextSwitch(this.targetFolder.getAbsolutePath());
        Map<String, String> file2text = javaModel2javaTextSwitch.generate(resources);
        ArrayList<String> fileKeys = new ArrayList<String>(file2text.keySet());
        Collections.sort(fileKeys);
        for (String fileKey : fileKeys) {
            String fileText = file2text.get(fileKey);
            File file = new File(fileKey);
            file.getParentFile().mkdirs();
            FileWriter fw = new FileWriter(file);
            fw.append(fileText);
            fw.close();
        }
    }

    @Override
    @Deprecated
    public String getModuleName() {
        return MODULE_FILE_NAME;
    }

    @Override
    @Deprecated
    public List<String> getProperties() {
        return this.propertiesFiles;
    }

    @Override
    @Deprecated
    public void addPropertiesFile(String propertiesFile) {
        this.propertiesFiles.add(propertiesFile);
    }

    @Override
    @Deprecated
    public String[] getTemplateNames() {
        return TEMPLATE_NAMES;
    }
}

