/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.internal.browser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;

public class QueryHistory {
    private static final int HISTORY_LIMIT = 50;
    private static final String FILE_NAME = String.valueOf(MemoryAnalyserPlugin.getDefault().getStateLocation().toOSString()) + File.separator + "commandHistory.ser";
    private static LinkedList<String> history = null;

    public static synchronized void addQuery(String queryString) {
        if (history == null) {
            QueryHistory.loadHistory();
        }
        Iterator iter = history.iterator();
        while (iter.hasNext()) {
            String item = (String)iter.next();
            if (!queryString.equals(item)) continue;
            iter.remove();
            break;
        }
        history.addFirst(queryString);
        while (history.size() > 50) {
            history.removeLast();
        }
        QueryHistory.saveHistory();
    }

    public static synchronized List<String> getHistoryEntries() {
        if (history == null) {
            QueryHistory.loadHistory();
        }
        return new ArrayList<String>(history);
    }

    private static synchronized void loadHistory() {
        File file = new File(FILE_NAME);
        if (file.exists()) {
            try (ObjectInputStream oin = new ObjectInputStream(new FileInputStream(file)){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    String match = "java.lang.*;java.util.*;org.eclipse.mat.snapshot.*;org.eclipse.mat.ui.SnapshotHistoryService$Entry;!*";
                    String nm = desc.getName();
                    if (!nm.startsWith("[")) {
                        String[] stringArray = match.split(";");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String pt = stringArray[n2];
                            boolean not = pt.startsWith("!");
                            if (not) {
                                pt = pt.substring(1);
                            }
                            boolean m = pt.endsWith(".**") ? nm.startsWith(pt.substring(0, pt.length() - 2)) : (pt.endsWith(".*") ? nm.startsWith(pt.substring(0, pt.length() - 1)) && !nm.substring(pt.length() - 1).contains(".") : (pt.endsWith("*") ? nm.startsWith(pt.substring(0, pt.length() - 1)) : nm.equals(pt)));
                            if (not && m) {
                                throw new InvalidClassException(nm, match);
                            }
                            if (m) break;
                            ++n2;
                        }
                    }
                    return super.resolveClass(desc);
                }
            };){
                history = (LinkedList)oin.readObject();
            }
            catch (Exception ignore) {
                MemoryAnalyserPlugin.log(ignore);
            }
        }
        if (history == null) {
            history = new LinkedList();
        }
    }

    private static void saveHistory() {
        block10: {
            try {
                if (!history.isEmpty()) {
                    try (FileOutputStream out = new FileOutputStream(FILE_NAME);
                         ObjectOutputStream oout = new ObjectOutputStream(out);){
                        oout.writeObject(history);
                        break block10;
                    }
                }
                File file = new File(FILE_NAME);
                if (!file.delete() && file.exists()) {
                    throw new IOException(file.getAbsolutePath());
                }
            }
            catch (IOException ignore) {
                MemoryAnalyserPlugin.log(ignore);
            }
        }
    }
}

