/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import java.util.Iterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.layout.BlockFlow;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigure;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigureLayout;
import org.eclipse.jst.pagedesigner.css2.layout.PageFlowLayout;

public class FlowPage
extends BlockFlow {
    private Dimension _pageSize = new Dimension();
    private int _recommendedWidth;
    private int[] _pageSizeCacheKeys = new int[4];
    private Dimension[] _pageSizeCacheValues = new Dimension[4];

    @Override
    protected FlowFigureLayout createDefaultFlowLayout() {
        return new PageFlowLayout(this);
    }

    public Dimension getMinimumSize(int w, int h) {
        return this.getPreferredSize(w, h);
    }

    public void invalidate() {
        this._pageSizeCacheValues = new Dimension[4];
        super.invalidate();
    }

    public Dimension getPreferredSize(int width, int h) {
        if (width >= 0) {
            width = Math.max(0, width - this.getInsets().getWidth());
        }
        int i = 0;
        while (i < 4) {
            if (this._pageSizeCacheKeys[i] == width && this._pageSizeCacheValues[i] != null) {
                return this._pageSizeCacheValues[i];
            }
            ++i;
        }
        this._pageSizeCacheKeys[3] = this._pageSizeCacheKeys[2];
        this._pageSizeCacheKeys[2] = this._pageSizeCacheKeys[1];
        this._pageSizeCacheKeys[1] = this._pageSizeCacheKeys[0];
        this._pageSizeCacheKeys[0] = width;
        this._pageSizeCacheValues[3] = this._pageSizeCacheValues[2];
        this._pageSizeCacheValues[2] = this._pageSizeCacheValues[1];
        this._pageSizeCacheValues[1] = this._pageSizeCacheValues[0];
        int oldWidth = this.getRecommendedWidth();
        this.setRecommendedWidth(width);
        this.validate();
        this._pageSizeCacheValues[0] = this._pageSize.getExpanded(this.getInsets().getWidth(), this.getInsets().getHeight());
        if (width != oldWidth) {
            this.setRecommendedWidth(oldWidth);
            this.getUpdateManager().addInvalidFigure((IFigure)this);
        }
        return this._pageSizeCacheValues[0];
    }

    int getRecommendedWidth() {
        return this._recommendedWidth;
    }

    @Override
    public void postValidate() {
        Rectangle r = this.getBlockBox().toRectangle();
        this._pageSize.width = r.width;
        this._pageSize.height = r.height;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            ((FlowFigure)((Object)it.next())).postValidate();
        }
    }

    @Override
    public void setBounds(Rectangle r) {
        if (this.getBounds().equals((Object)r)) {
            return;
        }
        boolean invalidate = this.getBounds().width != r.width || this.getBounds().height != r.height;
        super.setBounds(r);
        int newWidth = r.width - this.getInsets().getWidth();
        if (invalidate || this.getRecommendedWidth() != newWidth) {
            this.setRecommendedWidth(newWidth);
            this.getUpdateManager().addInvalidFigure((IFigure)this);
        }
    }

    private void setRecommendedWidth(int width) {
        if (this._recommendedWidth == width) {
            return;
        }
        this._recommendedWidth = width;
        super.invalidate();
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        super.validate();
        this.postValidate();
    }

    public void setValid(boolean value) {
        super.setValid(value);
    }

    public Insets getInsets() {
        return new Insets(8);
    }
}

