/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties;

import java.util.Vector;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.PageflowMessages;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowElement;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties.PagePathDialogCellEditor;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.util.PageflowValidation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class PageflowElementPropertySource
implements IPropertySource {
    private static final String PAGEFLOW_PATH = "path";
    static final String PAGEFLOW_NAME = "name";
    static final String PAGEFLOW_COMMENT = "comment";
    private static final String PAGEFLOW_CONFIG_FILE = "configfile";
    PageflowElement element;
    private static final String P_VALUE_TRUE_LABEL = PageflowMessages.Pageflow_Label_True;
    private static final String P_VALUE_FALSE_LABEL = PageflowMessages.Pageflow_Label_False;
    private static final int P_VALUE_TRUE = 0;
    private static final int P_VALUE_FALSE = 1;

    public PageflowElementPropertySource(PageflowElement element) {
        this.element = element;
    }

    public Object getEditableValue() {
        return this.element;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        Vector<PropertyDescriptor> propertyDescriptors = new Vector<PropertyDescriptor>();
        EClass cls = this.element.eClass();
        for (EAttribute attr : cls.getEAllAttributes()) {
            Object propertyDescriptor;
            if (attr.isID() || attr.getFeatureID() == 7) continue;
            EDataType type = attr.getEAttributeType();
            if (type.getInstanceClass() == String.class) {
                propertyDescriptor = attr.getName().equalsIgnoreCase(PAGEFLOW_PATH) ? this.getPagePathPropertyDescriptor(attr) : (attr.getName().equalsIgnoreCase(PAGEFLOW_CONFIG_FILE) ? null : new TextPropertyDescriptor((Object)Integer.toString(attr.getFeatureID()), this.getString(attr.getName())));
                if (propertyDescriptor == null) continue;
                propertyDescriptor.setLabelProvider((ILabelProvider)new PageflowLabelProvider());
                propertyDescriptors.add((PropertyDescriptor)propertyDescriptor);
                continue;
            }
            if (type.getInstanceClass() != Boolean.TYPE) continue;
            propertyDescriptor = this.getBooleanTypePropertyDescriptor(attr);
            propertyDescriptor.setLabelProvider((ILabelProvider)new BooleanLabelProvider());
            propertyDescriptors.add((PropertyDescriptor)propertyDescriptor);
        }
        return propertyDescriptors.toArray(new IPropertyDescriptor[0]);
    }

    private PropertyDescriptor getPagePathPropertyDescriptor(EAttribute attr) {
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(Integer.toString(attr.getFeatureID()), this.getString(attr.getName())){

            public CellEditor createPropertyEditor(Composite parent) {
                PagePathDialogCellEditor editor = new PagePathDialogCellEditor(parent, (PageflowPage)PageflowElementPropertySource.this.element);
                if (this.getValidator() != null) {
                    editor.setValidator(this.getValidator());
                }
                return editor;
            }

            protected ICellEditorValidator getValidator() {
                return new ICellEditorValidator(){

                    public String isValid(Object value) {
                        if (((PageflowPage)(this).PageflowElementPropertySource.this.element).getPath() != null && value != null && !((PageflowPage)(this).PageflowElementPropertySource.this.element).getPath().equalsIgnoreCase((String)value) && PageflowValidation.getInstance().isExistedPage(((PageflowPage)(this).PageflowElementPropertySource.this.element).getPageflow(), (String)value)) {
                            EditorPlugin.getAlerts().error("Pageflow.PageflowEditor.Alert.DNDResourceTitle", "Pageflow.PageflowEditor.Alert.ExistingPage", value);
                            return EditorPlugin.getResourceString("Pageflow.PageflowEditor.Alert.ExistingPage");
                        }
                        return null;
                    }
                };
            }
        };
        return propertyDescriptor;
    }

    PropertyDescriptor getBooleanTypePropertyDescriptor(EAttribute attr) {
        ComboBoxPropertyDescriptor propertyDescriptor = new ComboBoxPropertyDescriptor((Object)Integer.toString(attr.getFeatureID()), this.getString(attr.getName()), new String[]{P_VALUE_TRUE_LABEL, P_VALUE_FALSE_LABEL});
        return propertyDescriptor;
    }

    protected final String getString(String key) {
        if (PAGEFLOW_COMMENT.equals(key)) {
            return PageflowMessages.Pageflow_Model_Attributes_comment;
        }
        if (PAGEFLOW_NAME.equals(key)) {
            return PageflowMessages.Pageflow_Model_Attributes_name;
        }
        if ("largeicon".equals(key)) {
            return PageflowMessages.Pageflow_Model_Attributes_largeicon;
        }
        if ("smallicon".equals(key)) {
            return PageflowMessages.Pageflow_Model_Attributes_smallicon;
        }
        if ("source".equals(key)) {
            return PageflowMessages.Pageflow_Model_Attributes_source;
        }
        if ("target".equals(key)) {
            return PageflowMessages.Pageflow_Model_Attributes_target;
        }
        if ("fromaction".equals(key)) {
            return PageflowMessages.Pageflow_Model_Attributes_fromaction;
        }
        if (PAGEFLOW_PATH.equals(key)) {
            return PageflowMessages.Pageflow_Model_Attributes_path;
        }
        if ("begin".equals(key)) {
            return PageflowMessages.Pageflow_Model_Attributes_begin;
        }
        if ("end".equals(key)) {
            return PageflowMessages.Pageflow_Model_Attributes_end;
        }
        if (PAGEFLOW_CONFIG_FILE.equals(key)) {
            return PageflowMessages.Pageflow_Model_Attributes_configfile;
        }
        if ("outcome".equals(key)) {
            return PageflowMessages.Pageflow_Model_Attributes_outcome;
        }
        if ("redirect".equals(key)) {
            return PageflowMessages.Pageflow_Model_Attributes_redirect;
        }
        return "";
    }

    public Object getPropertyValue(Object id) {
        EStructuralFeature feature = this.element.eClass().getEStructuralFeature(Integer.parseInt((String)id));
        Object result = this.element.eGet(feature);
        if (result instanceof Boolean) {
            result = result == Boolean.TRUE ? new Integer(0) : new Integer(1);
        }
        return result != null ? result : "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        EStructuralFeature feature = this.element.eClass().getEStructuralFeature(Integer.parseInt((String)id));
        Object result = this.element.eGet(feature);
        if (result instanceof Boolean) {
            value = value.equals(new Integer(0)) ? Boolean.TRUE : Boolean.FALSE;
        }
        this.element.eSet(feature, value);
    }

    static class BooleanLabelProvider
    extends LabelProvider {
        BooleanLabelProvider() {
        }

        public String getText(Object element) {
            String[] values = new String[]{P_VALUE_TRUE_LABEL, P_VALUE_FALSE_LABEL};
            return values[(Integer)element];
        }

        public Image getImage(Object element) {
            return EditorPlugin.getDefault().getImage("facesconfig/Pageflow_BooleanValue.gif");
        }
    }

    static class PageflowLabelProvider
    extends LabelProvider {
        PageflowLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof String) {
                return EditorPlugin.getDefault().getImage("facesconfig/Pageflow_TextValue.gif");
            }
            if (element instanceof Integer) {
                return EditorPlugin.getDefault().getImage("facesconfig/Pageflow_IntegralValue.gif");
            }
            return EditorPlugin.getDefault().getImage("facesconfig/Pageflow_GenericValue.gif");
        }
    }
}

