/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsfappconfig;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.AbstractJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.jsfappconfig.JARFileJSFAppConfigProvider;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;

public class RuntimeClasspathJSFAppConfigLocater
extends AbstractJSFAppConfigLocater
implements IElementChangedListener {
    @Override
    public void startLocating() {
        this.locateProviders();
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    @Override
    public void stopLocating() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    public void locateProviders() {
        try {
            List JARs = JSFAppConfigUtils.getConfigFileJARsFromClasspath(this.getJSFAppConfigManager().getProject());
            Iterator itJARs = JARs.iterator();
            LinkedHashSet<JARFileJSFAppConfigProvider> newConfigProviders = new LinkedHashSet<JARFileJSFAppConfigProvider>();
            while (itJARs.hasNext()) {
                String JARFilename = (String)itJARs.next();
                JARFileJSFAppConfigProvider configProvider = new JARFileJSFAppConfigProvider(JARFilename);
                newConfigProviders.add(configProvider);
            }
            this.updateConfigProviders(newConfigProviders);
        }
        catch (CoreException ce) {
            JSFCorePlugin.log(4, ce.getLocalizedMessage(), ce);
        }
        catch (IOException ioe) {
            JSFCorePlugin.log(4, ioe.getLocalizedMessage(), ioe);
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        if (this.classpathChanged(event.getDelta())) {
            this.locateProviders();
        }
    }

    protected boolean classpathChanged(IJavaElementDelta delta) {
        int deltaFlags = delta.getFlags();
        if ((deltaFlags & 0x40) == 64 || (deltaFlags & 0x8000) == 32768 || (deltaFlags & 0x80) == 128) {
            return true;
        }
        boolean changed = false;
        IJavaElementDelta[] childDeltas = delta.getAffectedChildren();
        if (childDeltas != null) {
            int i = 0;
            while (i < childDeltas.length) {
                if (this.classpathChanged(childDeltas[i])) {
                    changed = true;
                    break;
                }
                ++i;
            }
        }
        return changed;
    }
}

