/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.options;

import java.util.Collection;
import org.eclipse.jpt.common.ui.JptCommonUiMessages;
import org.eclipse.jpt.common.ui.internal.widgets.EnumFormComboViewer;
import org.eclipse.jpt.common.ui.internal.widgets.FileChooserComboPane;
import org.eclipse.jpt.common.ui.internal.widgets.Pane;
import org.eclipse.jpt.common.ui.internal.widgets.TriStateCheckBox;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkLogging;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkLoggingLevel;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.EclipseLinkHelpContextIds;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.persistence.options.EclipseLinkLoggerClassChooser;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class EclipseLinkLoggingComposite<T extends EclipseLinkLogging>
extends Pane<T> {
    public EclipseLinkLoggingComposite(Pane<?> parent, PropertyValueModel<T> subjectModel, Composite parentComposite) {
        super(parent, subjectModel, parentComposite);
    }

    protected Composite addComposite(Composite container) {
        return this.addSubPane(container, 2, 0, 0, 0, 0);
    }

    protected void initializeLayout(Composite container) {
        this.addLabel(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_LOGGING_LEVEL_LABEL);
        this.addLoggingLevelCombo(container);
        this.logPropertiesComposite(container);
        this.addLabel(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_LOGGING_FILE_LABEL);
        this.addLogFileLocationComposite(container);
        Hyperlink loggerHyperlink = this.addHyperlink(container, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_LOGGER_LABEL);
        new EclipseLinkLoggerClassChooser(this, container, loggerHyperlink);
    }

    protected void logPropertiesComposite(Composite parent) {
        TriStateCheckBox timestampCheckBox = this.addTriStateCheckBoxWithDefault(parent, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_TIMESTAMP_LABEL, this.buildTimestampHolder(), this.buildTimestampStringHolder(), EclipseLinkHelpContextIds.PERSISTENCE_LOGGING_TIMESTAMP);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        timestampCheckBox.getCheckBox().setLayoutData((Object)gridData);
        TriStateCheckBox threadCheckBox = this.addTriStateCheckBoxWithDefault(parent, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_THREAD_LABEL, this.buildThreadHolder(), this.buildThreadStringHolder(), EclipseLinkHelpContextIds.PERSISTENCE_LOGGING_THREAD);
        threadCheckBox.getCheckBox().setLayoutData((Object)gridData);
        TriStateCheckBox sessionCheckBox = this.addTriStateCheckBoxWithDefault(parent, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_SESSION_LABEL, this.buildSessionHolder(), this.buildSessionStringHolder(), EclipseLinkHelpContextIds.PERSISTENCE_LOGGING_SESSION);
        sessionCheckBox.getCheckBox().setLayoutData((Object)gridData);
        TriStateCheckBox exceptionsCheckBox = this.addTriStateCheckBoxWithDefault(parent, JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_EXCEPTIONS_LABEL, this.buildExceptionsHolder(), this.buildExceptionsStringHolder(), EclipseLinkHelpContextIds.PERSISTENCE_LOGGING_EXCEPTIONS);
        exceptionsCheckBox.getCheckBox().setLayoutData((Object)gridData);
    }

    private EnumFormComboViewer<EclipseLinkLogging, EclipseLinkLoggingLevel> addLoggingLevelCombo(Composite container) {
        return new EnumFormComboViewer<EclipseLinkLogging, EclipseLinkLoggingLevel>((Pane)this, container){

            protected void addPropertyNames(Collection<String> propertyNames) {
                super.addPropertyNames(propertyNames);
                propertyNames.add("level");
            }

            protected EclipseLinkLoggingLevel[] getChoices() {
                return EclipseLinkLoggingLevel.values();
            }

            protected boolean sortChoices() {
                return false;
            }

            protected EclipseLinkLoggingLevel getDefaultValue() {
                return ((EclipseLinkLogging)this.getSubject()).getDefaultLevel();
            }

            protected String displayString(EclipseLinkLoggingLevel value) {
                switch (value) {
                    case all: {
                        return JptJpaEclipseLinkUiMessages.LOGGING_LEVEL_COMPOSITE_ALL;
                    }
                    case config: {
                        return JptJpaEclipseLinkUiMessages.LOGGING_LEVEL_COMPOSITE_CONFIG;
                    }
                    case fine: {
                        return JptJpaEclipseLinkUiMessages.LOGGING_LEVEL_COMPOSITE_FINE;
                    }
                    case finer: {
                        return JptJpaEclipseLinkUiMessages.LOGGING_LEVEL_COMPOSITE_FINER;
                    }
                    case finest: {
                        return JptJpaEclipseLinkUiMessages.LOGGING_LEVEL_COMPOSITE_FINEST;
                    }
                    case info: {
                        return JptJpaEclipseLinkUiMessages.LOGGING_LEVEL_COMPOSITE_INFO;
                    }
                    case off: {
                        return JptJpaEclipseLinkUiMessages.LOGGING_LEVEL_COMPOSITE_OFF;
                    }
                    case severe: {
                        return JptJpaEclipseLinkUiMessages.LOGGING_LEVEL_COMPOSITE_SEVERE;
                    }
                    case warning: {
                        return JptJpaEclipseLinkUiMessages.LOGGING_LEVEL_COMPOSITE_WARNING;
                    }
                }
                throw new IllegalStateException();
            }

            protected EclipseLinkLoggingLevel getValue() {
                return ((EclipseLinkLogging)this.getSubject()).getLevel();
            }

            protected void setValue(EclipseLinkLoggingLevel value) {
                ((EclipseLinkLogging)this.getSubject()).setLevel(value);
            }

            protected String getHelpId() {
                return EclipseLinkHelpContextIds.PERSISTENCE_LOGGING_LEVEL;
            }
        };
    }

    private FileChooserComboPane<EclipseLinkLogging> addLogFileLocationComposite(Composite parent) {
        return new FileChooserComboPane<EclipseLinkLogging>((Pane)this, parent){

            protected ModifiablePropertyValueModel<String> buildTextHolder() {
                return new PropertyAspectAdapter<EclipseLinkLogging, String>(this.getSubjectHolder(), new String[]{"logFileLocation"}){

                    protected String buildValue_() {
                        String name = ((EclipseLinkLogging)this.subject).getLogFileLocation();
                        if (name == null) {
                            name = this.defaultValue((EclipseLinkLogging)this.subject);
                        }
                        return name;
                    }

                    protected void setValue_(String value) {
                        if (this.defaultValue((EclipseLinkLogging)this.subject).equals(value)) {
                            value = null;
                        }
                        ((EclipseLinkLogging)this.subject).setLogFileLocation(value);
                    }
                };
            }

            private String defaultValue(EclipseLinkLogging subject) {
                String defaultValue = subject.getDefaultLogFileLocation();
                if (defaultValue != null) {
                    return NLS.bind((String)JptCommonUiMessages.DEFAULT_WITH_ONE_PARAM, (Object)defaultValue);
                }
                return this.getDefaultString();
            }

            protected String getDefaultString() {
                return JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_DEFAULT_STDOUT;
            }

            protected String getDialogTitle() {
                return JptJpaEclipseLinkUiMessages.LOGGING_FILE_LOCATION_COMPOSITE_DIALOG_TITLE;
            }

            protected String getProjectPath() {
                return ((EclipseLinkLogging)this.getSubject()).getJpaProject().getProject().getLocation().toString();
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildTimestampHolder() {
        return new PropertyAspectAdapter<EclipseLinkLogging, Boolean>(this.getSubjectHolder(), new String[]{"timestamp"}){

            protected Boolean buildValue_() {
                return ((EclipseLinkLogging)this.subject).getTimestamp();
            }

            protected void setValue_(Boolean value) {
                ((EclipseLinkLogging)this.subject).setTimestamp(value);
            }
        };
    }

    private PropertyValueModel<String> buildTimestampStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultTimestampHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_TIMESTAMP_LABEL_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_TIMESTAMP_LABEL;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultTimestampHolder() {
        return new PropertyAspectAdapter<EclipseLinkLogging, Boolean>(this.getSubjectHolder(), new String[]{"timestamp"}){

            protected Boolean buildValue_() {
                if (((EclipseLinkLogging)this.subject).getTimestamp() != null) {
                    return null;
                }
                return ((EclipseLinkLogging)this.subject).getDefaultTimestamp();
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildThreadHolder() {
        return new PropertyAspectAdapter<EclipseLinkLogging, Boolean>(this.getSubjectHolder(), new String[]{"thread"}){

            protected Boolean buildValue_() {
                return ((EclipseLinkLogging)this.subject).getThread();
            }

            protected void setValue_(Boolean value) {
                ((EclipseLinkLogging)this.subject).setThread(value);
            }
        };
    }

    private PropertyValueModel<String> buildThreadStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultThreadHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_THREAD_LABEL_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_THREAD_LABEL;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultThreadHolder() {
        return new PropertyAspectAdapter<EclipseLinkLogging, Boolean>(this.getSubjectHolder(), new String[]{"thread"}){

            protected Boolean buildValue_() {
                if (((EclipseLinkLogging)this.subject).getThread() != null) {
                    return null;
                }
                return ((EclipseLinkLogging)this.subject).getDefaultThread();
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildSessionHolder() {
        return new PropertyAspectAdapter<EclipseLinkLogging, Boolean>(this.getSubjectHolder(), new String[]{"session"}){

            protected Boolean buildValue_() {
                return ((EclipseLinkLogging)this.subject).getSession();
            }

            protected void setValue_(Boolean value) {
                ((EclipseLinkLogging)this.subject).setSession(value);
            }
        };
    }

    private PropertyValueModel<String> buildSessionStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultSessionHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_SESSION_LABEL_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_SESSION_LABEL;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultSessionHolder() {
        return new PropertyAspectAdapter<EclipseLinkLogging, Boolean>(this.getSubjectHolder(), new String[]{"session"}){

            protected Boolean buildValue_() {
                if (((EclipseLinkLogging)this.subject).getSession() != null) {
                    return null;
                }
                return ((EclipseLinkLogging)this.subject).getDefaultSession();
            }
        };
    }

    private ModifiablePropertyValueModel<Boolean> buildExceptionsHolder() {
        return new PropertyAspectAdapter<EclipseLinkLogging, Boolean>(this.getSubjectHolder(), new String[]{"exceptions"}){

            protected Boolean buildValue_() {
                return ((EclipseLinkLogging)this.subject).getExceptions();
            }

            protected void setValue_(Boolean value) {
                ((EclipseLinkLogging)this.subject).setExceptions(value);
            }
        };
    }

    private PropertyValueModel<String> buildExceptionsStringHolder() {
        return new TransformationPropertyValueModel<Boolean, String>(this.buildDefaultExceptionsHolder()){

            protected String transform(Boolean value) {
                if (value != null) {
                    String defaultStringValue = value != false ? JptCommonUiMessages.BOOLEAN_TRUE : JptCommonUiMessages.BOOLEAN_FALSE;
                    return NLS.bind((String)JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_EXCEPTIONS_LABEL_DEFAULT, (Object)defaultStringValue);
                }
                return JptJpaEclipseLinkUiMessages.PERSISTENCE_XML_LOGGING_TAB_EXCEPTIONS_LABEL;
            }
        };
    }

    private PropertyValueModel<Boolean> buildDefaultExceptionsHolder() {
        return new PropertyAspectAdapter<EclipseLinkLogging, Boolean>(this.getSubjectHolder(), new String[]{"exceptions"}){

            protected Boolean buildValue_() {
                if (((EclipseLinkLogging)this.subject).getExceptions() != null) {
                    return null;
                }
                return ((EclipseLinkLogging)this.subject).getDefaultExceptions();
            }
        };
    }
}

