/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.figures;

import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Transform;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.ui.internal.figures.GFPolygon;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementDelegate;

public class GFPolygonDecoration
extends GFPolygon
implements RotatableDecoration {
    private Point decoratorLocation = new Point();
    private Point decoratorReferencePoint = new Point();
    private PointList decoratorTemplate = new PointList();

    public GFPolygonDecoration(IPictogramElementDelegate pictogramElementDelegate, GraphicsAlgorithm graphicsAlgorithm) {
        super(pictogramElementDelegate, graphicsAlgorithm);
    }

    public void setDecoratorTemplate(PointList points) {
        this.decoratorTemplate.removeAllPoints();
        this.decoratorTemplate.addAll(points);
        this.processRotatableDecorationValues();
    }

    public void setLocation(Point p) {
        this.decoratorLocation.setLocation(p);
        this.processRotatableDecorationValues();
    }

    public void setReferencePoint(Point ref) {
        this.decoratorReferencePoint.setLocation(ref);
        this.processRotatableDecorationValues();
    }

    protected void processRotatableDecorationValues() {
        Transform transform = new Transform();
        transform.setTranslation((double)this.getDecoratorLocation().x, (double)this.getDecoratorLocation().y);
        transform.setRotation(Math.atan2(this.getDecoratorLocation().y - this.getDecoratorReferencePoint().y, this.getDecoratorLocation().x - this.getDecoratorReferencePoint().x));
        PointList newPoints = new PointList();
        int i = 0;
        while (i < this.decoratorTemplate.size()) {
            newPoints.addPoint(transform.getTransformed(this.decoratorTemplate.getPoint(i)));
            ++i;
        }
        this.setPoints(newPoints);
    }

    protected final Point getDecoratorLocation() {
        return this.decoratorLocation;
    }

    protected final Point getDecoratorReferencePoint() {
        return this.decoratorReferencePoint;
    }

    protected final PointList getDecoratorTemplate() {
        return this.decoratorTemplate;
    }
}

