/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.server.InternalTransaction;

public class ResetTransactionIndication
extends CDOServerReadIndication {
    private int transactionID;
    private int commitNumber;

    public ResetTransactionIndication(CDOServerProtocol protocol) {
        super(protocol, (short)61);
    }

    @Override
    protected void indicating(CDODataInput in) throws IOException {
        this.transactionID = in.readXInt();
        this.commitNumber = in.readXInt();
    }

    @Override
    protected void responding(CDODataOutput out) throws IOException {
        InternalTransaction transaction = (InternalTransaction)this.getView(this.transactionID);
        InternalTransaction.CommitAttempt lastCommitSuccess = transaction.getLastCommitAttempt();
        if (lastCommitSuccess != null && lastCommitSuccess.getCommitNumber() == this.commitNumber) {
            out.writeBoolean(true);
            out.writeXLong(lastCommitSuccess.getTimeStamp());
            out.writeXLong(lastCommitSuccess.getPreviousTimeStamp());
        } else {
            out.writeBoolean(false);
        }
    }
}

