/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.ProposalSorterHandle;
import org.eclipse.dltk.ui.text.completion.ScriptTextMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public final class ProposalSorterRegistry {
    private static final String EXTENSION_POINT = "scriptCompletionProposalSorters";
    private static final String DEFAULT_ID = "org.eclipse.dltk.ui.RelevanceSorter";
    private static ProposalSorterRegistry fInstance;
    private final IPreferenceStore fPreferenceStore;
    private final String fKey;
    private Map<String, ProposalSorterHandle> fSorters = null;
    private ProposalSorterHandle fDefaultSorter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ProposalSorterRegistry getDefault() {
        if (fInstance != null) return fInstance;
        Class<ProposalSorterRegistry> clazz = ProposalSorterRegistry.class;
        synchronized (ProposalSorterRegistry.class) {
            if (fInstance != null) return fInstance;
            fInstance = new ProposalSorterRegistry(DLTKUIPlugin.getDefault().getPreferenceStore(), "content_assist_sorter");
            // ** MonitorExit[var0] (shouldn't be in output)
            return fInstance;
        }
    }

    private ProposalSorterRegistry(IPreferenceStore preferenceStore, String key) {
        Assert.isTrue((preferenceStore != null ? 1 : 0) != 0);
        Assert.isTrue((key != null ? 1 : 0) != 0);
        this.fPreferenceStore = preferenceStore;
        this.fKey = key;
    }

    public ProposalSorterHandle getCurrentSorter() {
        this.ensureSortersRead();
        String id = this.fPreferenceStore.getString(this.fKey);
        ProposalSorterHandle sorter = this.fSorters.get(id);
        return sorter != null ? sorter : this.fDefaultSorter;
    }

    private synchronized void ensureSortersRead() {
        if (this.fSorters != null) {
            return;
        }
        LinkedHashMap<String, ProposalSorterHandle> sorters = new LinkedHashMap<String, ProposalSorterHandle>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<IConfigurationElement> elements = new ArrayList<IConfigurationElement>(Arrays.asList(registry.getConfigurationElementsFor("org.eclipse.dltk.ui", EXTENSION_POINT)));
        for (IConfigurationElement element : elements) {
            try {
                ProposalSorterHandle handle = new ProposalSorterHandle(element);
                String id = handle.getId();
                sorters.put(id, handle);
                if (!DEFAULT_ID.equals(id)) continue;
                this.fDefaultSorter = handle;
            }
            catch (InvalidRegistryObjectException x) {
                String message = MessageFormat.format(ScriptTextMessages.CompletionProposalComputerRegistry_invalid_message, element.toString());
                Status status = new Status(2, "org.eclipse.dltk.ui", 0, message, (Throwable)x);
                this.informUser((IStatus)status);
            }
        }
        this.fSorters = sorters;
    }

    private void informUser(IStatus status) {
        DLTKUIPlugin.log(status);
        String title = ScriptTextMessages.CompletionProposalComputerRegistry_error_dialog_title;
        String message = status.getMessage();
        MessageDialog.openError((Shell)DLTKUIPlugin.getActiveWorkbenchShell(), (String)title, (String)message);
    }

    public ProposalSorterHandle[] getSorters() {
        this.ensureSortersRead();
        Collection<ProposalSorterHandle> sorters = this.fSorters.values();
        return sorters.toArray(new ProposalSorterHandle[sorters.size()]);
    }

    public void select(ProposalSorterHandle handle) {
        Assert.isTrue((handle != null ? 1 : 0) != 0);
        String id = handle.getId();
        this.fPreferenceStore.setValue(this.fKey, id);
    }
}

