/*******************************************************************************
 * Copyright (c) 2000, 2018 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 *******************************************************************************/
package org.eclipse.dltk.internal.corext.callhierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.dltk.core.IModelElement;

public class MethodCall {
	private IModelElement fMember;
	private List fCallLocations;

	/**
	 * @param enclosingElement
	 */
	public MethodCall(IModelElement enclosingElement) {
		this.fMember = enclosingElement;
	}

	/**
	 *
	 */
	public Collection getCallLocations() {
		return fCallLocations;
	}

	public CallLocation getFirstCallLocation() {
		if ((fCallLocations != null) && !fCallLocations.isEmpty()) {
			return (CallLocation) fCallLocations.get(0);
		}
		return null;
	}

	public boolean hasCallLocations() {
		return fCallLocations != null && fCallLocations.size() > 0;
	}

	/**
	 * @return Object
	 */
	public Object getKey() {
		return getMember().getHandleIdentifier();
	}

	/**
	 *
	 */
	public IModelElement getMember() {
		return fMember;
	}

	/**
	 * @param location
	 */
	public void addCallLocation(CallLocation location) {
		if (fCallLocations == null) {
			fCallLocations = new ArrayList();
		}

		fCallLocations.add(location);
	}
}
