/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.ui.drivers;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributor;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.datatools.connectivity.ui.wizards.OptionalPropertiesPane;
import org.eclipse.datatools.enablement.ibm.db2.luw.internal.ui.util.ResourceLoader;
import org.eclipse.datatools.enablement.ibm.internal.ui.drivers.IBMJDBCDriverTracingOptionsPane;
import org.eclipse.datatools.enablement.ibm.internal.ui.drivers.IIBMJDBCDriverProvider;
import org.eclipse.datatools.enablement.ibm.internal.ui.drivers.Messages;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class DB2LUWDriverUIContributorBase
implements IDriverUIContributor,
IIBMJDBCDriverProvider,
Listener {
    protected String CUI_NEWCW_DATABASE_LBL_UI_ = ResourceLoader.CUI_NEWCW_DATABASE_LBL_UI_;
    private static final String CUI_NEWCW_HOST_LBL_UI_ = ResourceLoader.CUI_NEWCW_HOST_LBL_UI_;
    private static final String CUI_NEWCW_PORT_LBL_UI_ = ResourceLoader.CUI_NEWCW_PORT_LBL_UI_;
    private static final String CUI_NEWCW_CONNECTIONURL_LBL_UI_ = ResourceLoader.CUI_NEWCW_CONNECTIONURL_LBL_UI_;
    private static final String CUI_NEWCW_CLIENTAUTHENTICATION_BTN_UI_ = ResourceLoader.CUI_NEWCW_CLIENTAUTHENTICATION_BTN_UI_;
    private static final String CUI_NEWCW_USERNAME_LBL_UI_ = ResourceLoader.CUI_NEWCW_USERNAME_LBL_UI_;
    private static final String CUI_NEWCW_PASSWORD_LBL_UI_ = ResourceLoader.CUI_NEWCW_PASSWORD_LBL_UI_;
    private static final String CUI_NEWCW_SAVE_PASSWORD_LBL_UI_ = ResourceLoader.CUI_NEWCW_SAVE_PASSWORD_LBL_UI_;
    private static final String CUI_NEWCW_DEFAULT_SCHEMA_LBL_UI_ = ResourceLoader.CUI_NEWCW_DEFAULT_SCHEMA_LBL_UI_;
    private static final String CUI_NEWCW_DRIVER_OPTIONS_TAB_UI_ = Messages.getString((String)"CUI_NEWCW_DRIVER_OPTIONS_TAB_UI_");
    private static final String CUI_NEWCW_TRACING_OPTIONS_TAB_UI_ = Messages.getString((String)"CUI_NEWCW_TRACING_OPTIONS_TAB_UI_");
    private static final String CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_ = ResourceLoader.CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_ = ResourceLoader.CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_ = ResourceLoader.CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_USE_CLIENT_AUTHENICATION_SUMMARY_DATA_TEXT_ = ResourceLoader.CUI_NEWCW_CLIENTAUTHENTICATION_BTN_UI_;
    private static final String CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_ = ResourceLoader.CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_DEFAULT_SCHEMA_SUMMARY_DATA_TEXT_ = ResourceLoader.CUI_NEWCW_DEFAULT_SCHEMA_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_ = ResourceLoader.CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_URL_SUMMARY_DATA_TEXT_ = ResourceLoader.CUI_NEWCW_URL_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ = ResourceLoader.CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_;
    private static final String CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_ = ResourceLoader.CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_;
    private static final String CLIENT_AUTHETICATION_TEXT = "securityMechanism=4;";
    private IBMJDBCDriverTracingOptionsPane tracingOptionsComposite;
    protected OptionalPropertiesPane optionalPropsComposite;
    private Label databaseLabel;
    protected Text databaseText;
    private Label hostLabel;
    protected Text hostText;
    private Label portLabel;
    protected Text portText;
    private Label usernameLabel;
    private Text usernameText;
    private Label passwordLabel;
    private Label defaultSchemaLabel;
    private Text defaultSchemaText;
    private Text passwordText;
    private Button savePasswordButton;
    private Label urlLabel;
    protected Text urlText;
    protected Button clientAuthenticationCheckbox;
    protected DialogPage parentPage;
    private ScrolledComposite parentComposite;
    private IDriverUIContributorInformation contributorInformation;
    private Properties properties;
    private String urlOptionalParameters = "";
    protected boolean isReadOnly = false;

    public Composite getContributedDriverUI(Composite parent, boolean isReadOnly) {
        if (this.parentComposite == null || this.parentComposite.isDisposed() || this.isReadOnly != isReadOnly) {
            this.isReadOnly = isReadOnly;
            int additionalStyles = 0;
            if (isReadOnly) {
                additionalStyles = 8;
            }
            this.parentComposite = new ScrolledComposite(parent, 768);
            this.parentComposite.setExpandHorizontal(true);
            this.parentComposite.setExpandVertical(true);
            this.parentComposite.setLayout((Layout)new GridLayout());
            TabFolder tabComposite = new TabFolder((Composite)this.parentComposite, 128);
            TabItem driverOptionsTab = new TabItem(tabComposite, 0);
            driverOptionsTab.setText(CUI_NEWCW_DRIVER_OPTIONS_TAB_UI_);
            if (this.includeTracingOptionsTab()) {
                TabItem tracingOptionsTab = new TabItem(tabComposite, 0);
                tracingOptionsTab.setText(CUI_NEWCW_TRACING_OPTIONS_TAB_UI_);
                this.tracingOptionsComposite = new IBMJDBCDriverTracingOptionsPane((Composite)tabComposite, 0, (IIBMJDBCDriverProvider)this, isReadOnly);
                tracingOptionsTab.setControl((Control)this.tracingOptionsComposite);
            }
            TabItem optionalPropsTab = new TabItem(tabComposite, 0);
            optionalPropsTab.setText(ConnectivityUIPlugin.getDefault().getResourceString("CommonDriverUIContributor.optionaltab"));
            this.optionalPropsComposite = this.createOptionalPropertiesPane((Composite)tabComposite, 0, isReadOnly);
            optionalPropsTab.setControl((Control)this.optionalPropsComposite);
            Composite driverOptionsComposite = new Composite((Composite)tabComposite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            driverOptionsComposite.setLayout((Layout)layout);
            driverOptionsTab.setControl((Control)driverOptionsComposite);
            this.databaseLabel = new Label(driverOptionsComposite, 0);
            this.databaseLabel.setText(this.CUI_NEWCW_DATABASE_LBL_UI_);
            GridData gd = new GridData();
            gd.verticalAlignment = 1;
            this.databaseLabel.setLayoutData((Object)gd);
            this.databaseText = new Text(driverOptionsComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.verticalAlignment = 1;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 2;
            this.databaseText.setLayoutData((Object)gd);
            this.hostLabel = new Label(driverOptionsComposite, 0);
            this.hostLabel.setText(CUI_NEWCW_HOST_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.hostLabel.setLayoutData((Object)gd);
            this.hostText = new Text(driverOptionsComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 2;
            gd.grabExcessHorizontalSpace = true;
            this.hostText.setLayoutData((Object)gd);
            this.portLabel = new Label(driverOptionsComposite, 0);
            this.portLabel.setText(CUI_NEWCW_PORT_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.portLabel.setLayoutData((Object)gd);
            this.portText = new Text(driverOptionsComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.portText.setLayoutData((Object)gd);
            this.clientAuthenticationCheckbox = new Button(driverOptionsComposite, 32);
            this.clientAuthenticationCheckbox.setText(CUI_NEWCW_CLIENTAUTHENTICATION_BTN_UI_);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 3;
            gd.grabExcessHorizontalSpace = true;
            this.clientAuthenticationCheckbox.setLayoutData((Object)gd);
            this.clientAuthenticationCheckbox.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (!DB2LUWDriverUIContributorBase.this.isReadOnly) {
                        if (((Button)e.widget).getSelection()) {
                            DB2LUWDriverUIContributorBase.this.enableAuthenticationControls(false);
                        } else {
                            DB2LUWDriverUIContributorBase.this.enableAuthenticationControls(true);
                        }
                    }
                }
            });
            this.usernameLabel = new Label(driverOptionsComposite, 0);
            this.usernameLabel.setText(CUI_NEWCW_USERNAME_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.usernameLabel.setLayoutData((Object)gd);
            this.usernameText = new Text(driverOptionsComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.usernameText.setLayoutData((Object)gd);
            this.passwordLabel = new Label(driverOptionsComposite, 0);
            this.passwordLabel.setText(CUI_NEWCW_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.passwordLabel.setLayoutData((Object)gd);
            this.passwordText = new Text(driverOptionsComposite, 0x400804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.passwordText.setLayoutData((Object)gd);
            this.savePasswordButton = new Button(driverOptionsComposite, 32);
            this.savePasswordButton.setText(CUI_NEWCW_SAVE_PASSWORD_LBL_UI_);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.horizontalSpan = 3;
            gd.grabExcessHorizontalSpace = true;
            this.savePasswordButton.setLayoutData((Object)gd);
            this.defaultSchemaLabel = new Label(driverOptionsComposite, 0);
            this.defaultSchemaLabel.setText(CUI_NEWCW_DEFAULT_SCHEMA_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.defaultSchemaLabel.setLayoutData((Object)gd);
            this.defaultSchemaText = new Text(driverOptionsComposite, 0x804 | additionalStyles);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.defaultSchemaText.setLayoutData((Object)gd);
            this.urlLabel = new Label(driverOptionsComposite, 0);
            this.urlLabel.setText(CUI_NEWCW_CONNECTIONURL_LBL_UI_);
            gd = new GridData();
            gd.verticalAlignment = 1;
            this.urlLabel.setLayoutData((Object)gd);
            this.urlText = new Text(driverOptionsComposite, 2634);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.verticalAlignment = 1;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            gd.widthHint = 190;
            gd.heightHint = 90;
            this.urlText.setLayoutData((Object)gd);
            this.parentComposite.setContent((Control)tabComposite);
            this.parentComposite.setMinSize(tabComposite.computeSize(-1, -1));
            this.initialize();
        }
        return this.parentComposite;
    }

    protected void enableAuthenticationControls(boolean enabled) {
        this.usernameLabel.setEnabled(enabled);
        this.usernameText.setEnabled(enabled);
        this.passwordLabel.setEnabled(enabled);
        this.passwordText.setEnabled(enabled);
        this.savePasswordButton.setEnabled(enabled);
    }

    public void setConnectionInformation() {
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.databaseName", this.databaseText.getText().trim());
        if (!this.clientAuthenticationCheckbox.getSelection()) {
            this.properties.setProperty("org.eclipse.datatools.connectivity.db.username", this.usernameText.getText());
            this.properties.setProperty("org.eclipse.datatools.connectivity.db.password", this.passwordText.getText());
            this.properties.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(this.savePasswordButton.getSelection()));
        } else {
            this.properties.setProperty("org.eclipse.datatools.connectivity.db.username", System.getProperty("user.name"));
            this.properties.remove("org.eclipse.datatools.connectivity.db.password");
            this.properties.setProperty("org.eclipse.datatools.connectivity.db.savePWD", String.valueOf(false));
        }
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.defaultSchema", this.defaultSchemaText.getText().trim());
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.URL", this.urlText.getText().trim());
        this.optionalPropsComposite.setConnectionInformation();
        this.contributorInformation.setProperties(this.properties);
    }

    public void updateURL() {
        String tracingProperties = this.includeTracingOptionsTab() && this.tracingOptionsComposite != null ? this.tracingOptionsComposite.getTracingURLProperties() : "";
        String url = this.getURLHandle(this.hostText.getText().trim(), this.portText.getText().trim(), this.databaseText.getText().trim(), this.clientAuthenticationCheckbox.getSelection(), tracingProperties).formatURL();
        url = String.valueOf(url) + this.getURLOptionalParameters();
        this.urlText.setText(url);
    }

    private void removeListeners() {
        this.databaseText.removeListener(24, (Listener)this);
        this.hostText.removeListener(24, (Listener)this);
        this.portText.removeListener(24, (Listener)this);
        this.usernameText.removeListener(24, (Listener)this);
        this.passwordText.removeListener(24, (Listener)this);
        this.savePasswordButton.removeListener(13, (Listener)this);
        this.defaultSchemaText.removeListener(24, (Listener)this);
        this.clientAuthenticationCheckbox.removeListener(13, (Listener)this);
    }

    private void addListeners() {
        this.databaseText.addListener(24, (Listener)this);
        this.hostText.addListener(24, (Listener)this);
        this.portText.addListener(24, (Listener)this);
        this.usernameText.addListener(24, (Listener)this);
        this.passwordText.addListener(24, (Listener)this);
        this.savePasswordButton.addListener(13, (Listener)this);
        this.defaultSchemaText.addListener(24, (Listener)this);
        this.clientAuthenticationCheckbox.addListener(13, (Listener)this);
    }

    private void initialize() {
        this.updateURL();
        this.addListeners();
    }

    public void handleEvent(Event event) {
        if (this.isReadOnly) {
            if (event.widget == this.savePasswordButton) {
                this.savePasswordButton.setSelection(!this.savePasswordButton.getSelection());
            } else if (event.widget == this.clientAuthenticationCheckbox) {
                this.clientAuthenticationCheckbox.setSelection(!this.clientAuthenticationCheckbox.getSelection());
            }
        } else {
            this.updateURL();
            this.setConnectionInformation();
        }
    }

    public boolean determineContributorCompletion() {
        boolean isComplete = true;
        if (this.databaseText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(MessageFormat.format((String)ResourceLoader.CUI_NEWCW_VALIDATE_DATABASE_REQ_UI_, (Object[])new Object[]{ResourceLoader.CUI_NEWCW_DEFDBNAME_VAL_UI_}));
            isComplete = false;
        } else if (this.hostText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(ResourceLoader.CUI_NEWCW_VALIDATE_HOST_REQ_UI_);
            isComplete = false;
        } else if (this.portText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(ResourceLoader.CUI_NEWCW_VALIDATE_PORT_REQ_UI_);
            isComplete = false;
        } else if (!this.clientAuthenticationCheckbox.getSelection() && this.usernameText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(ResourceLoader.CUI_NEWCW_VALIDATE_USERID_REQ_UI_);
            isComplete = false;
        } else if (!this.clientAuthenticationCheckbox.getSelection() && this.passwordText.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(ResourceLoader.CUI_NEWCW_VALIDATE_PASSWORD_REQ_UI_);
            isComplete = false;
        } else if (this.tracingOptionsComposite != null && !this.tracingOptionsComposite.validateControl(this.parentPage)) {
            isComplete = false;
        } else if (!this.optionalPropsComposite.validateControl(this.parentPage)) {
            isComplete = false;
        }
        if (isComplete) {
            this.parentPage.setErrorMessage(null);
        }
        return isComplete;
    }

    public void setDialogPage(DialogPage parentPage) {
        this.parentPage = parentPage;
    }

    public void setDriverUIContributorInformation(IDriverUIContributorInformation contributorInformation) {
        this.contributorInformation = contributorInformation;
        this.properties = contributorInformation.getProperties();
        this.optionalPropsComposite.setDriverUIContributorInformation(contributorInformation);
    }

    public void loadProperties() {
        String defaultSchema;
        String savePassword;
        String password;
        String username;
        this.removeListeners();
        DB2JDBCURL url = this.getURLHandle(this.properties.getProperty("org.eclipse.datatools.connectivity.db.URL"));
        String host = this.properties.getProperty("hostname");
        if (host != null) {
            this.hostText.setText(host);
        } else {
            this.hostText.setText(url.getNode());
        }
        String port = this.properties.getProperty("port");
        if (port != null) {
            this.portText.setText(port);
        } else {
            this.portText.setText(url.getPort());
        }
        String database = this.properties.getProperty("org.eclipse.datatools.connectivity.db.databaseName");
        if (database != null) {
            this.databaseText.setText(database);
        } else {
            this.databaseText.setText(url.getDatabaseName());
        }
        if (url.useClientAuthentication()) {
            this.clientAuthenticationCheckbox.setSelection(true);
            this.enableAuthenticationControls(false);
        }
        if ((username = this.properties.getProperty("org.eclipse.datatools.connectivity.db.username")) != null) {
            this.usernameText.setText(username);
        }
        if ((password = this.properties.getProperty("org.eclipse.datatools.connectivity.db.password")) != null) {
            this.passwordText.setText(password);
        }
        if ((savePassword = this.properties.getProperty("org.eclipse.datatools.connectivity.db.savePWD")) != null && Boolean.valueOf(savePassword) == Boolean.TRUE) {
            this.savePasswordButton.setSelection(true);
        }
        if ((defaultSchema = this.properties.getProperty("org.eclipse.datatools.connectivity.db.defaultSchema")) != null) {
            this.defaultSchemaText.setText(defaultSchema);
        }
        if (this.tracingOptionsComposite != null) {
            this.tracingOptionsComposite.loadProperties(url.getProperties());
        }
        this.optionalPropsComposite.loadProperties();
        this.updateURL();
        this.addListeners();
        this.setConnectionInformation();
    }

    public List getSummaryData() {
        ArrayList<String[]> summaryData = new ArrayList<String[]>();
        summaryData.add(new String[]{CUI_NEWCW_DATABASE_SUMMARY_DATA_TEXT_, this.databaseText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_HOST_SUMMARY_DATA_TEXT_, this.hostText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_PORT_SUMMARY_DATA_TEXT_, this.portText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_USE_CLIENT_AUTHENICATION_SUMMARY_DATA_TEXT_, this.clientAuthenticationCheckbox.getSelection() ? CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ : CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_});
        if (!this.clientAuthenticationCheckbox.getSelection()) {
            summaryData.add(new String[]{CUI_NEWCW_USERNAME_SUMMARY_DATA_TEXT_, this.usernameText.getText().trim()});
            summaryData.add(new String[]{CUI_NEWCW_SAVE_PASSWORD_SUMMARY_DATA_TEXT_, this.savePasswordButton.getSelection() ? CUI_NEWCW_TRUE_SUMMARY_DATA_TEXT_ : CUI_NEWCW_FALSE_SUMMARY_DATA_TEXT_});
        }
        summaryData.add(new String[]{CUI_NEWCW_DEFAULT_SCHEMA_SUMMARY_DATA_TEXT_, this.defaultSchemaText.getText().trim()});
        summaryData.add(new String[]{CUI_NEWCW_URL_SUMMARY_DATA_TEXT_, this.urlText.getText().trim()});
        return summaryData;
    }

    protected boolean includeTracingOptionsTab() {
        return true;
    }

    protected OptionalPropertiesPane createOptionalPropertiesPane(Composite parent, int style, boolean useReadOnlyControls) {
        return new OptionalPropertiesPane(parent, style, useReadOnlyControls);
    }

    protected DB2JDBCURL getURLHandle(String url) {
        return new DB2JDBCURL(url);
    }

    protected DB2JDBCURL getURLHandle(String node, String port, String databaseName, boolean useClientAuthentication, String tracingProperties) {
        return new DB2JDBCURL(node, port, databaseName, useClientAuthentication, tracingProperties);
    }

    public void setURLOptionalParameters(String connProp) {
        this.urlOptionalParameters = connProp;
    }

    public String getURLOptionalParameters() {
        return this.urlOptionalParameters;
    }

    protected class DB2JDBCURL {
        protected String subprotocol = "";
        protected String node = "";
        protected String port = "";
        protected String databaseName = "";
        protected String urlProperties = "";
        protected boolean useClientAuthentication = false;

        public DB2JDBCURL(String url) {
            if (url != null) {
                this.parseURL(url);
            }
        }

        public DB2JDBCURL(String node, String port, String databaseName, boolean useClientAuthentication, String tracingProperties) {
            this.node = node;
            this.port = port;
            this.databaseName = databaseName;
            this.useClientAuthentication = useClientAuthentication;
            this.urlProperties = tracingProperties;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getNode() {
            return this.node;
        }

        public String getSubprotocol() {
            return this.subprotocol;
        }

        public String getPort() {
            return this.port;
        }

        public String getProperties() {
            return this.urlProperties;
        }

        public boolean useClientAuthentication() {
            return this.useClientAuthentication;
        }

        protected String formatURL() {
            String url = "jdbc:db2://" + this.formatNode(this.getNode()) + ":" + this.getPort() + "/" + this.getDatabaseName() + ":retrieveMessagesFromServerOnGetMessage=true;";
            if (this.useClientAuthentication()) {
                url = String.valueOf(url) + DB2LUWDriverUIContributorBase.CLIENT_AUTHETICATION_TEXT;
            }
            if (this.urlProperties != null && this.urlProperties.length() > 0) {
                url = String.valueOf(url) + this.urlProperties;
            }
            url = String.valueOf(url) + DB2LUWDriverUIContributorBase.this.getURLOptionalParameters();
            return url;
        }

        public String getBaseURL() {
            String url = "jdbc:db2://" + this.formatNode(this.getNode()) + ":" + this.getPort() + "/" + this.getDatabaseName() + ":retrieveMessagesFromServerOnGetMessage=true;";
            if (this.useClientAuthentication()) {
                url = String.valueOf(url) + DB2LUWDriverUIContributorBase.CLIENT_AUTHETICATION_TEXT;
            }
            return url;
        }

        private String formatNode(String node) {
            if (node.indexOf(":") > -1) {
                return "[" + node + "]";
            }
            return node;
        }

        protected void parseURL(String url) {
            try {
                DB2LUWDriverUIContributorBase.this.setURLOptionalParameters("");
                String remainingURL = url.substring(url.indexOf(58) + 1);
                this.subprotocol = remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 3);
                this.node = remainingURL.substring(0, remainingURL.indexOf(47));
                if (this.node.indexOf(91) > -1 && this.node.indexOf("]:") > -1) {
                    this.port = this.node.substring(this.node.indexOf("]:") + 2);
                    this.node = this.node.substring(1, this.node.indexOf("]:"));
                } else if (this.node.indexOf(58) > -1) {
                    this.port = this.node.substring(this.node.indexOf(58) + 1);
                    this.node = this.node.substring(0, this.node.indexOf(58));
                }
                remainingURL = remainingURL.substring(remainingURL.indexOf(47) + 1);
                if (remainingURL.indexOf(58) > -1) {
                    this.databaseName = remainingURL.substring(0, remainingURL.indexOf(58));
                    this.urlProperties = remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 1);
                    this.useClientAuthentication = this.urlProperties.indexOf(DB2LUWDriverUIContributorBase.CLIENT_AUTHETICATION_TEXT) > -1;
                } else if (remainingURL.indexOf(59) > -1) {
                    this.databaseName = remainingURL.substring(0, remainingURL.indexOf(59));
                    remainingURL = remainingURL.substring(remainingURL.indexOf(59) + 1);
                } else {
                    this.databaseName = remainingURL;
                    remainingURL = "";
                }
                String userOptionalParameters = "";
                String userParameter = "";
                if (remainingURL != null && remainingURL.length() > 0) {
                    StringTokenizer st = new StringTokenizer(remainingURL, ";");
                    int tokenLength = st.countTokens();
                    int i = 0;
                    while (i < tokenLength) {
                        userParameter = st.nextToken();
                        if (userParameter != null && userParameter.length() > 0) {
                            if (!(userParameter.startsWith("retrieveMessagesFromServerOnGetMessage") || userParameter.equals("securityMechanism=4") || userParameter.startsWith("traceFile") || userParameter.startsWith("traceFileAppend") || userParameter.startsWith("traceLevel") || userParameter.startsWith("traceDirectory"))) {
                                userOptionalParameters = String.valueOf(userOptionalParameters) + userParameter + ";";
                            }
                            if (userParameter.equals("securityMechanism=4")) {
                                this.useClientAuthentication = true;
                            }
                        }
                        ++i;
                    }
                    DB2LUWDriverUIContributorBase.this.setURLOptionalParameters(userOptionalParameters);
                }
            }
            catch (Exception exception) {}
        }
    }
}

