/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractEnumerableAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.IntArrays;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.VisibleForTesting;

public class AtomicIntegerArrayAssert
extends AbstractEnumerableAssert<AtomicIntegerArrayAssert, AtomicIntegerArray, Integer> {
    @VisibleForTesting
    protected IntArrays arrays = IntArrays.instance();
    private int[] array;

    public AtomicIntegerArrayAssert(AtomicIntegerArray actual) {
        super(actual, AtomicIntegerArrayAssert.class);
        this.array = Arrays.array(actual);
    }

    @Override
    public void isNullOrEmpty() {
        if (this.actual == null) {
            return;
        }
        this.isEmpty();
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, this.array);
    }

    @Override
    public AtomicIntegerArrayAssert isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, this.array);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert hasArray(int[] expected) {
        this.arrays.assertContainsExactly(this.info, this.array, expected);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    @Override
    public AtomicIntegerArrayAssert hasSize(int expected) {
        this.arrays.assertHasSize(this.info, this.array, expected);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    @Override
    public AtomicIntegerArrayAssert hasSizeGreaterThan(int boundary) {
        this.arrays.assertHasSizeGreaterThan(this.info, this.array, boundary);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    @Override
    public AtomicIntegerArrayAssert hasSizeGreaterThanOrEqualTo(int boundary) {
        this.arrays.assertHasSizeGreaterThanOrEqualTo(this.info, this.array, boundary);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    @Override
    public AtomicIntegerArrayAssert hasSizeLessThan(int boundary) {
        this.arrays.assertHasSizeLessThan(this.info, this.array, boundary);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    @Override
    public AtomicIntegerArrayAssert hasSizeLessThanOrEqualTo(int boundary) {
        this.arrays.assertHasSizeLessThanOrEqualTo(this.info, this.array, boundary);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    @Override
    public AtomicIntegerArrayAssert hasSizeBetween(int lowerBoundary, int higherBoundary) {
        this.arrays.assertHasSizeBetween(this.info, this.array, lowerBoundary, higherBoundary);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    @Override
    public AtomicIntegerArrayAssert hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, this.array, other);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert contains(int ... values) {
        this.arrays.assertContains(this.info, this.array, values);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert containsOnly(int ... values) {
        this.arrays.assertContainsOnly(this.info, this.array, values);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert containsOnlyOnce(int ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, this.array, values);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert containsSequence(int ... sequence) {
        this.arrays.assertContainsSequence(this.info, this.array, sequence);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert containsSubsequence(int ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, this.array, subsequence);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert contains(int value, Index index) {
        this.arrays.assertContains(this.info, this.array, value, index);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert doesNotContain(int ... values) {
        this.arrays.assertDoesNotContain(this.info, this.array, values);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert doesNotContain(int value, Index index) {
        this.arrays.assertDoesNotContain(this.info, this.array, value, index);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, this.array);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert startsWith(int ... sequence) {
        this.arrays.assertStartsWith(this.info, this.array, sequence);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert endsWith(int ... sequence) {
        this.arrays.assertEndsWith(this.info, this.array, sequence);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert isSorted() {
        this.arrays.assertIsSorted(this.info, this.array);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert isSortedAccordingTo(Comparator<? super Integer> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, this.array, comparator);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    @Override
    @CheckReturnValue
    public AtomicIntegerArrayAssert usingElementComparator(Comparator<? super Integer> customComparator) {
        this.arrays = new IntArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (AtomicIntegerArrayAssert)this.myself;
    }

    @Override
    @CheckReturnValue
    public AtomicIntegerArrayAssert usingDefaultElementComparator() {
        this.arrays = IntArrays.instance();
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert containsExactly(int ... values) {
        this.arrays.assertContainsExactly(this.info, this.array, values);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert containsExactlyInAnyOrder(int ... values) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, this.array, values);
        return (AtomicIntegerArrayAssert)this.myself;
    }

    public AtomicIntegerArrayAssert containsAnyOf(int ... values) {
        this.arrays.assertContainsAnyOf(this.info, this.array, values);
        return (AtomicIntegerArrayAssert)this.myself;
    }
}

