/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.assertj.versionrange;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertFactory;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.test.assertj.versionrange.AbstractVersionBoundAssert;
import org.osgi.test.assertj.versionrange.VersionBoundAssert;

public abstract class AbstractVersionRangeAssert<SELF extends AbstractVersionRangeAssert<SELF, ACTUAL>, ACTUAL extends VersionRange>
extends AbstractAssert<SELF, ACTUAL> {
    protected AbstractVersionRangeAssert(ACTUAL actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public AbstractVersionBoundAssert<?, ?> hasLeftThat() {
        return (AbstractVersionBoundAssert)((AbstractVersionRangeAssert)this.isNotNull()).extracting(VersionRange::getLeft, (AssertFactory)VersionBoundAssert.versionBoundAssertFactory(((VersionRange)this.actual).getLeftType() == '('));
    }

    public SELF hasLeft(String expected) {
        return this.hasLeft(Version.valueOf((String)expected));
    }

    public SELF hasLeft(Version expected) {
        this.isNotNull();
        Version a = ((VersionRange)this.actual).getLeft();
        if (!Objects.equals(expected, a)) {
            throw this.failureWithActualExpected(a, expected, "%nExpecting version range%n <%s>%nto have lower bound:%n <%s>%n but it was:%n <%s>", new Object[]{this.actual, expected, a});
        }
        return (SELF)((Object)((AbstractVersionRangeAssert)this.myself));
    }

    public SELF isLeftOpen() {
        this.isNotNull();
        if (((VersionRange)this.actual).getLeftType() != '(') {
            throw this.failure("%nExpecting version range%n <%s>%nto have open lower bound%n but it was closed", new Object[]{this.actual});
        }
        return (SELF)((Object)((AbstractVersionRangeAssert)this.myself));
    }

    public SELF isLeftClosed() {
        this.isNotNull();
        if (((VersionRange)this.actual).getLeftType() != '[') {
            throw this.failure("%nExpecting version range%n <%s>%nto have closed lower bound%n but it was open", new Object[]{this.actual});
        }
        return (SELF)((Object)((AbstractVersionRangeAssert)this.myself));
    }

    public AbstractVersionBoundAssert<?, ?> hasRightThat() {
        return (AbstractVersionBoundAssert)((AbstractVersionRangeAssert)this.isNotNull()).extracting(VersionRange::getRight, (AssertFactory)VersionBoundAssert.versionBoundAssertFactory(((VersionRange)this.actual).getRightType() == ')'));
    }

    public SELF hasRight(String expected) {
        return this.hasRight(Version.valueOf((String)expected));
    }

    public SELF hasRight(Version expected) {
        this.isNotNull();
        Version a = ((VersionRange)this.actual).getRight();
        if (!Objects.equals(expected, a)) {
            throw this.failureWithActualExpected(a, expected, "%nExpecting version range%n <%s>%nto have upper bound:%n <%s>%n but it was:%n <%s>", new Object[]{this.actual, expected, a});
        }
        return (SELF)((Object)((AbstractVersionRangeAssert)this.myself));
    }

    public SELF isRightOpen() {
        this.isNotNull();
        if (((VersionRange)this.actual).getRightType() != ')') {
            throw this.failure("%nExpecting version range%n <%s>%nto have open upper bound%nbut it was closed", new Object[]{this.actual});
        }
        return (SELF)((Object)((AbstractVersionRangeAssert)this.myself));
    }

    public SELF isRightClosed() {
        this.isNotNull();
        if (((VersionRange)this.actual).getRightType() != ']') {
            throw this.failure("%nExpecting version range%n <%s>%nto have closed upper bound%nbut it was open", new Object[]{this.actual});
        }
        return (SELF)((Object)((AbstractVersionRangeAssert)this.myself));
    }

    public SELF includes(String version) {
        return this.includes(Version.valueOf((String)version));
    }

    public SELF includes(Version version) {
        this.isNotNull();
        if (!((VersionRange)this.actual).includes(version)) {
            throw this.failure("%nExpecting version range%n <%s>%nto include version%n <%s>%nbut it does not", new Object[]{this.actual, version});
        }
        return (SELF)((Object)((AbstractVersionRangeAssert)this.myself));
    }

    public SELF doesNotInclude(String version) {
        return this.doesNotInclude(Version.valueOf((String)version));
    }

    public SELF doesNotInclude(Version version) {
        this.isNotNull();
        if (((VersionRange)this.actual).includes(version)) {
            throw this.failure("%nExpecting version range%n <%s>%nto not include version%n <%s>%nbut it does", new Object[]{this.actual, version});
        }
        return (SELF)((Object)((AbstractVersionRangeAssert)this.myself));
    }

    public SELF isEmpty() {
        this.isNotNull();
        if (!((VersionRange)this.actual).isEmpty()) {
            throw this.failure("%nExpecting version range%n <%s>%nto be empty%nbut it was not", new Object[]{this.actual});
        }
        return (SELF)((Object)((AbstractVersionRangeAssert)this.myself));
    }

    public SELF isNotEmpty() {
        this.isNotNull();
        if (((VersionRange)this.actual).isEmpty()) {
            throw this.failure("%nExpecting version range%n <%s>%nto be empty%nbut it was not", new Object[]{this.actual});
        }
        return (SELF)((Object)((AbstractVersionRangeAssert)this.myself));
    }

    public SELF isExact() {
        this.isNotNull();
        if (!((VersionRange)this.actual).isExact()) {
            throw this.failure("%nExpecting version range%n <%s>%nto be exact%nbut it was not", new Object[]{this.actual});
        }
        return (SELF)((Object)((AbstractVersionRangeAssert)this.myself));
    }

    public SELF isNotExact() {
        this.isNotNull();
        if (((VersionRange)this.actual).isExact()) {
            throw this.failure("%nExpecting version range%n <%s>%nto be exact%nbut it was not", new Object[]{this.actual});
        }
        return (SELF)((Object)((AbstractVersionRangeAssert)this.myself));
    }

    public SELF intersects(String ... version) {
        return this.intersects((VersionRange[])Stream.of(version).map(VersionRange::valueOf).toArray(VersionRange[]::new));
    }

    public SELF intersects(VersionRange ... versions) {
        this.isNotNull();
        if (((VersionRange)this.actual).intersection(versions).isEmpty()) {
            throw this.failure("%nExpecting version range%n <%s>%nto intersect all of%n <%s>%nbut it does not", new Object[]{this.actual, Arrays.toString(versions)});
        }
        return (SELF)((Object)((AbstractVersionRangeAssert)this.myself));
    }

    public SELF doesNotIntersect(String ... versions) {
        return this.doesNotIntersect((VersionRange[])Stream.of(versions).map(VersionRange::valueOf).toArray(VersionRange[]::new));
    }

    public SELF doesNotIntersect(VersionRange ... versions) {
        this.isNotNull();
        VersionRange intersection = ((VersionRange)this.actual).intersection(versions);
        if (!intersection.isEmpty()) {
            throw this.failure("%nExpecting version range%n <%s>%nto not intersect any of%n <%s>%nbut it has intersection%n <%s>", new Object[]{this.actual, Arrays.toString(versions), intersection});
        }
        return (SELF)((Object)((AbstractVersionRangeAssert)this.myself));
    }
}

