/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public class PatternStrings {
    public static String getSignature(IJavaScriptElement element) {
        if (element == null) {
            return null;
        }
        switch (element.getElementType()) {
            case 9: {
                return PatternStrings.getMethodSignature((IFunction)element);
            }
            case 7: {
                return PatternStrings.getTypeSignature((IType)element);
            }
            case 8: {
                return PatternStrings.getFieldSignature((IField)element);
            }
        }
        return element.getElementName();
    }

    public static String getMethodSignature(IFunction method) {
        StringBuffer buffer = new StringBuffer();
        if (method.getDeclaringType() != null) {
            buffer.append(JavaScriptElementLabels.getElementLabel((IJavaScriptElement)method.getDeclaringType(), 0x1000000040000L));
            boolean isConstructor = method.getElementName().equals(method.getDeclaringType().getElementName());
            if (!isConstructor) {
                buffer.append('.');
            }
            buffer.append(PatternStrings.getUnqualifiedMethodSignature(method, !isConstructor));
        }
        return buffer.toString();
    }

    private static String getUnqualifiedMethodSignature(IFunction method, boolean includeName) {
        StringBuffer buffer = new StringBuffer();
        if (includeName) {
            buffer.append(method.getElementName());
        }
        buffer.append('(');
        String[] types = method.getParameterTypes();
        int i = 0;
        while (i < types.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            String typeSig = Signature.toString((String)types[i]);
            buffer.append(typeSig);
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public static String getUnqualifiedMethodSignature(IFunction method) {
        return PatternStrings.getUnqualifiedMethodSignature(method, true);
    }

    public static String getTypeSignature(IType field) {
        return JavaScriptElementLabels.getElementLabel((IJavaScriptElement)field, 281474979069952L);
    }

    public static String getFieldSignature(IField field) {
        return JavaScriptElementLabels.getElementLabel((IJavaScriptElement)field, 65536L);
    }
}

