/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.wb.core.model.IJavaInfoInitializationParticipator;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddAfter;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;

public class LayoutJavaInfoParticipator
implements IJavaInfoInitializationParticipator {
    public static final Object INSTANCE = new LayoutJavaInfoParticipator();

    private LayoutJavaInfoParticipator() {
    }

    public void process(JavaInfo javaInfo) throws Exception {
        if (javaInfo instanceof LayoutInfo) {
            final LayoutInfo layout = (LayoutInfo)javaInfo;
            if (layout.getParent() != null) {
                this.performBindings(layout);
            } else {
                layout.addBroadcastListener(new ObjectInfoChildAddAfter(){

                    public void invoke(ObjectInfo parent, ObjectInfo child) throws Exception {
                        if (child == layout) {
                            layout.removeBroadcastListener(this);
                            LayoutJavaInfoParticipator.this.performBindings(layout);
                        }
                    }
                });
            }
        }
    }

    private void performBindings(LayoutInfo layout) throws Exception {
        LayoutJavaInfoParticipator.run(layout, new IBindingProcessor(){

            @Override
            public boolean run(LayoutInfo layout, ClassLoader classLoader, Class<?> layoutClass, String layoutName) throws Exception {
                String surroundClassName = layoutName + "SurroundSupport";
                Class<?> surroundClass = classLoader.loadClass(surroundClassName);
                ReflectionUtils.getConstructor(surroundClass, (Class[])new Class[]{layoutClass}).newInstance(layout);
                return true;
            }
        });
    }

    private static void run(LayoutInfo layout, IBindingProcessor processor) {
        Class<?> layoutClass = layout.getClass();
        while (layoutClass != null) {
            Class<?> finalLayoutClass = layoutClass;
            boolean success = (Boolean)ExecutionUtils.runObjectIgnore(() -> {
                LayoutJavaInfoParticipator.run(layout, processor, finalLayoutClass);
                return true;
            }, (Object)false);
            if (success) {
                return;
            }
            layoutClass = layoutClass.getSuperclass();
        }
    }

    private static void run(LayoutInfo layout, IBindingProcessor processor, Class<?> layoutClass) throws Exception {
        String layoutClassName = layoutClass.getName();
        String layoutName = StringUtils.removeEnd((String)layoutClassName, (String)"Info");
        ClassLoader classLoader = ReflectionUtils.getClassLoader(layoutClass);
        processor.run(layout, classLoader, layoutClass, layoutName);
    }

    private static interface IBindingProcessor {
        public boolean run(LayoutInfo var1, ClassLoader var2, Class<?> var3, String var4) throws Exception;
    }
}

