/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.tree;

import java.util.List;
import org.eclipse.gef.Request;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.internal.gef.tree.tools.DoubleClickEditPartTracker;

public abstract class TreeEditPart
extends EditPart {
    private TreeItem m_widget;
    private boolean m_expandedShouldRestore;
    private boolean m_expanded;

    public TreeItem getWidget() {
        return this.m_widget;
    }

    public void setWidget(TreeItem widget) {
        this.m_widget = widget;
        List children = this.getChildren();
        if (this.m_widget == null) {
            for (org.eclipse.gef.EditPart editPart : children) {
                TreeEditPart treePart = (TreeEditPart)editPart;
                treePart.setWidget(null);
            }
        } else {
            this.m_widget.setData((Object)this);
            this.m_widget.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    TreeEditPart.this.m_expandedShouldRestore = true;
                    TreeEditPart.this.m_expanded = TreeEditPart.this.m_widget.getExpanded();
                }
            });
        }
    }

    protected void addChildVisual(org.eclipse.gef.EditPart childPart, int index) {
        TreeEditPart treePart = (TreeEditPart)childPart;
        treePart.setWidget(new TreeItem(this.getWidget(), 0, index));
    }

    protected void removeChildVisual(org.eclipse.gef.EditPart childPart) {
        TreeEditPart treePart = (TreeEditPart)childPart;
        if (treePart.getWidget() != null) {
            treePart.getWidget().dispose();
            treePart.setWidget(null);
        }
    }

    @Override
    protected void updateChildVisual(EditPart childPart, int index) {
        TreeEditPart treePart = (TreeEditPart)childPart;
        if (treePart.getWidget() == null) {
            treePart.setWidget(new TreeItem(this.getWidget(), 0, index));
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.m_expandedShouldRestore) {
            this.m_expandedShouldRestore = false;
            TreeItem widget = this.getWidget();
            if (widget != null && !widget.isDisposed()) {
                widget.setExpanded(this.m_expanded);
            }
        }
    }

    @Override
    protected void createEditPolicies() {
    }

    public Tool getDragTracker(Request request) {
        return new DoubleClickEditPartTracker((org.eclipse.gef.EditPart)this);
    }
}

