/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.core.gef.part.AbstractComponentEditPart;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.actions.errors.ErrorsAction;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

public final class OpenErrorLogEditPolicy
extends EditPolicy {
    private static final Object KEY = OpenErrorLogEditPolicy.class;
    private final AbstractComponentEditPart m_editPart;
    private final JavaInfo m_javaInfo;
    private IFigure m_figure;

    public static void install(AbstractComponentEditPart editPart) {
        OpenErrorLogEditPolicy policy = new OpenErrorLogEditPolicy(editPart);
        editPart.installEditPolicy(KEY, (org.eclipse.gef.EditPolicy)policy);
    }

    public static void refresh(AbstractComponentEditPart editPart) {
        OpenErrorLogEditPolicy policy = (OpenErrorLogEditPolicy)editPart.getEditPolicy(KEY);
        if (policy != null) {
            policy.refresh();
        }
    }

    public OpenErrorLogEditPolicy(AbstractComponentEditPart editPart) {
        this.m_editPart = editPart;
        this.m_javaInfo = this.m_editPart.getComponent();
    }

    private void refresh() {
        if (this.m_javaInfo.isPlaceholder()) {
            if (this.m_figure == null) {
                this.createFigure();
            }
            if (this.m_figure.getParent() == null) {
                this.m_editPart.getFigure().add(this.m_figure);
            }
        } else {
            FigureUtils.removeFigure((IFigure)this.m_figure);
        }
    }

    private void createFigure() {
        Locator locator = new Locator(){

            public void relocate(IFigure target) {
                IFigure componentFigure = OpenErrorLogEditPolicy.this.m_editPart.getFigure();
                Rectangle componentArea = componentFigure.getClientArea();
                target.setBounds(new Rectangle(5, componentArea.bottom() - 5 - 16, 16, 16));
            }
        };
        this.m_figure = new Handle((GraphicalEditPart)this.m_editPart, locator){

            protected void paintClientArea(Graphics graphics) {
                Image icon = DesignerPlugin.getImage((String)"actions/errors/errors.gif");
                graphics.drawImage(icon, 0, 0);
            }
        };
        this.m_figure.addMouseListener((MouseListener)new MouseListener.Stub(){

            public void mousePressed(MouseEvent event) {
                OpenErrorLogEditPolicy.this.scheduleOpenErrorLog();
            }
        });
    }

    private void scheduleOpenErrorLog() {
        ExecutionUtils.runLogLater((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                OpenErrorLogEditPolicy.this.openErrorLog();
            }
        });
    }

    private void openErrorLog() {
        ErrorsAction errorsAction = new ErrorsAction();
        errorsAction.setRoot(this.m_javaInfo.getRoot());
        errorsAction.run();
    }
}

