/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScroller;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTScroller;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class Slider
extends Control {
    boolean dragging;
    int minimum;
    int maximum;
    int thumb;
    int increment = 1;
    int pageIncrement = 10;

    public Slider(Composite parent, int style) {
        super(parent, Slider.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.addTypedListener(listener, 13, 14);
    }

    static int checkStyle(int style) {
        return Slider.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 0x100) != 0) {
            height = (int)NSScroller.scrollerWidthForControlSize(((NSScroller)this.view).controlSize());
            width = height * 10;
        } else {
            width = (int)NSScroller.scrollerWidthForControlSize(((NSScroller)this.view).controlSize());
            height = width * 10;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width, height);
    }

    @Override
    void createHandle() {
        NSScroller widget = (NSScroller)new SWTScroller().alloc();
        NSRect rect = new NSRect();
        if ((this.style & 0x100) != 0) {
            rect.width = 1.0;
        } else {
            rect.height = 1.0;
        }
        widget.initWithFrame(rect);
        widget.setEnabled(true);
        widget.setTarget(widget);
        widget.setAction(OS.sel_sendSelection);
        this.view = widget;
        this.updateBar(0, this.minimum, this.maximum, this.thumb);
    }

    @Override
    void createWidget() {
        this.maximum = 100;
        this.thumb = 10;
        super.createWidget();
    }

    @Override
    NSFont defaultNSFont() {
        return this.display.scrollerFont;
    }

    @Override
    void enableWidget(boolean enabled) {
        int range;
        super.enableWidget(enabled);
        if (enabled && (range = this.maximum - this.thumb - this.minimum) <= 0) {
            ((NSScroller)this.view).setEnabled(false);
        }
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        return this.maximum;
    }

    public int getMinimum() {
        this.checkWidget();
        return this.minimum;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public int getSelection() {
        this.checkWidget();
        NSScroller widget = (NSScroller)this.view;
        double value = widget.doubleValue();
        return (int)(0.5 + ((double)(this.maximum - this.thumb - this.minimum) * value + (double)this.minimum));
    }

    public int getThumb() {
        this.checkWidget();
        return this.thumb;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    @Override
    void sendSelection() {
        Event event = new Event();
        int hitPart = (int)((NSScroller)this.view).hitPart();
        int value = this.getSelection();
        switch (hitPart) {
            case 4: {
                event.detail = 0x1000001;
                value -= this.increment;
                break;
            }
            case 1: {
                value -= this.pageIncrement;
                event.detail = 0x1000005;
                break;
            }
            case 5: {
                value += this.increment;
                event.detail = 0x1000002;
                break;
            }
            case 3: {
                value += this.pageIncrement;
                event.detail = 0x1000006;
                break;
            }
            case 2: {
                event.detail = 1;
            }
        }
        if (event.detail != 1) {
            this.setSelection(value);
        }
        this.sendSelectionEvent(13, event, true);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.increment = value;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        if (value <= this.minimum) {
            return;
        }
        if (value - this.minimum < this.thumb) {
            this.thumb = value - this.minimum;
        }
        int selection = Math.max(this.minimum, Math.min(this.getSelection(), value - this.thumb));
        this.maximum = value;
        this.updateBar(selection, this.minimum, value, this.thumb);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        if (value >= this.maximum) {
            return;
        }
        if (this.maximum - value < this.thumb) {
            this.thumb = this.maximum - value;
        }
        int selection = Math.min(this.maximum - this.thumb, Math.max(this.getSelection(), value));
        this.minimum = value;
        this.updateBar(selection, value, this.maximum, this.thumb);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        this.pageIncrement = value;
    }

    public void setSelection(int value) {
        this.checkWidget();
        this.updateBar(value, this.minimum, this.maximum, this.thumb);
    }

    @Override
    void setSmallSize() {
    }

    void updateBar(int selection, int minimum, int maximum, int thumb) {
        NSScroller widget = (NSScroller)this.view;
        selection = Math.max(minimum, Math.min(maximum - thumb, selection));
        int range = maximum - thumb - minimum;
        float fraction = range <= 0 ? 1.0f : (float)(selection - minimum) / (float)range;
        float knob = range <= 0 ? 1.0f : (float)thumb / (float)(maximum - minimum);
        widget.setDoubleValue(fraction);
        widget.setKnobProportion(knob);
        widget.setEnabled(range > 0);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        value = Math.min(value, this.maximum - this.minimum);
        this.updateBar(this.getSelection(), this.minimum, this.maximum, value);
        this.thumb = value;
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        this.thumb = thumb = Math.min(thumb, maximum - minimum);
        this.maximum = maximum;
        this.minimum = minimum;
        this.increment = increment;
        this.pageIncrement = pageIncrement;
        this.updateBar(selection, minimum, maximum, thumb);
    }
}

