/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.internal.importexport.RemoteImportExportPlugin;
import org.eclipse.rse.internal.importexport.files.IRemoteFileExportDescriptionReader;
import org.eclipse.rse.internal.importexport.files.RemoteFileExportData;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RemoteFileExportDescriptionReader
implements IRemoteFileExportDescriptionReader {
    protected InputStream fInputStream;

    public RemoteFileExportDescriptionReader(InputStream inputStream) {
        Assert.isNotNull((Object)inputStream);
        this.fInputStream = new BufferedInputStream(inputStream);
    }

    public void read(RemoteFileExportData exportData) throws CoreException {
        try {
            this.readXML(exportData);
        }
        catch (IOException ex) {
            String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
            throw new CoreException((IStatus)new Status(4, RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, message, (Throwable)ex));
        }
        catch (SAXException ex) {
            String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
            throw new CoreException((IStatus)new Status(4, RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, message, (Throwable)ex));
        }
    }

    public RemoteFileExportData readXML(RemoteFileExportData exportData) throws IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        DocumentBuilder parser = null;
        try {
            parser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
        Element xmlFileDesc = parser.parse(new InputSource(this.fInputStream)).getDocumentElement();
        if (!xmlFileDesc.getNodeName().equals("rexpfd")) {
            throw new IOException();
        }
        NodeList topLevelElements = xmlFileDesc.getChildNodes();
        int i = 0;
        while (i < topLevelElements.getLength()) {
            Node node = topLevelElements.item(i);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                this.xmlReadDestinationLocation(exportData, element);
                this.xmlReadOptions(exportData, element);
                this.xmlReadSelectedElements(exportData, element);
            }
            ++i;
        }
        return exportData;
    }

    private void xmlReadDestinationLocation(RemoteFileExportData exportData, Element element) {
        if (element.getNodeName().equals("destination")) {
            exportData.setDestination(element.getAttribute("path"));
        }
    }

    private void xmlReadOptions(RemoteFileExportData exportData, Element element) throws IOException {
        if (element.getNodeName().equals("options")) {
            try {
                exportData.setReviewSynchronize(this.getBooleanAttribute(element, "reviewSynchronize"));
            }
            catch (IOException e) {
                exportData.setReviewSynchronize(false);
            }
            exportData.setOverWriteExistingFiles(this.getBooleanAttribute(element, "overWriteExistingFiles"));
            exportData.setCreateDirectoryStructure(this.getBooleanAttribute(element, "createDirectoryStructure"));
            exportData.setCreateSelectionOnly(this.getBooleanAttribute(element, "createSelectedOnly"));
            exportData.setSaveSettings(this.getBooleanAttribute(element, "saveSettings"));
            exportData.setDescriptionFilePath(element.getAttribute("descriptionFilePath"));
        }
    }

    private void xmlReadSelectedElements(RemoteFileExportData exportData, Element element) throws IOException {
        if (element.getNodeName().equals("selectedElements")) {
            NodeList selectedElements = element.getChildNodes();
            ArrayList elementsToExport = new ArrayList(selectedElements.getLength());
            int j = 0;
            while (j < selectedElements.getLength()) {
                Node selectedNode = selectedElements.item(j);
                if (selectedNode.getNodeType() == 1) {
                    Element selectedElement = (Element)selectedNode;
                    if (selectedElement.getNodeName().equals("file")) {
                        this.addFile(elementsToExport, selectedElement);
                    } else if (selectedElement.getNodeName().equals("folder")) {
                        this.addFolder(elementsToExport, selectedElement);
                    } else if (selectedElement.getNodeName().equals("project")) {
                        this.addProject(elementsToExport, selectedElement);
                    }
                }
                ++j;
            }
            exportData.setElements(elementsToExport);
        }
    }

    private void addFile(List selectedElements, Element element) throws IOException {
        IFile file;
        IPath path = this.getPath(element);
        if (path != null && (file = SystemBasePlugin.getWorkspace().getRoot().getFile(path)) != null) {
            selectedElements.add(file);
        }
    }

    private void addFolder(List selectedElements, Element element) throws IOException {
        IFolder folder;
        IPath path = this.getPath(element);
        if (path != null && (folder = SystemBasePlugin.getWorkspace().getRoot().getFolder(path)) != null) {
            selectedElements.add(folder);
        }
    }

    private void addProject(List selectedElements, Element element) throws IOException {
        String name = element.getAttribute("name");
        if (name.equals("")) {
            throw new IOException();
        }
        IProject project = SystemBasePlugin.getWorkspace().getRoot().getProject(name);
        if (project != null) {
            selectedElements.add(project);
        }
    }

    private IPath getPath(Element element) throws IOException {
        String pathString = element.getAttribute("path");
        if (pathString.equals("")) {
            throw new IOException();
        }
        return new Path(element.getAttribute("path"));
    }

    protected boolean getBooleanAttribute(Element element, String name) throws IOException {
        String value = element.getAttribute(name);
        if (value != null && value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value != null && value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new IOException();
    }

    public void close() throws CoreException {
        if (this.fInputStream != null) {
            try {
                this.fInputStream.close();
            }
            catch (IOException ex) {
                String message = ex.getLocalizedMessage() != null ? ex.getLocalizedMessage() : "";
                throw new CoreException((IStatus)new Status(4, RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, message, (Throwable)ex));
            }
        }
    }

    public IStatus getStatus() {
        return new Status(0, RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, "", null);
    }
}

