/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.changes;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.refactoring.core.changes.Messages;

public class PHPProjectMoveChange
extends Change {
    private URI fNewLocation;
    private String fProjectName;
    private IProject fProject;

    public PHPProjectMoveChange(URI newLocation, String projectName) {
        this.fNewLocation = newLocation;
        this.fProjectName = projectName;
        this.fProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.fProjectName);
    }

    public Object getModifiedElement() {
        return this.fProject;
    }

    public String getName() {
        return Messages.PHPProjectMoveChange_0;
    }

    public void initializeValidationData(IProgressMonitor arg0) {
    }

    public RefactoringStatus isValid(IProgressMonitor arg0) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor monitor) throws CoreException {
        monitor.setTaskName("Moving project...");
        IProjectDescription description = this.fProject.getDescription();
        URI newDestinationURI = description.getLocationURI();
        description.setLocationURI(this.fNewLocation);
        this.fProject.move(description, 33, monitor);
        return new PHPProjectMoveChange(newDestinationURI, this.fProjectName);
    }
}

