/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.launch;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.php.composer.core.launch.ScriptNotFoundException;
import org.eclipse.php.composer.core.launch.environment.Environment;
import org.eclipse.php.composer.core.launch.execution.ExecutionResponseListener;
import org.eclipse.php.composer.core.launch.execution.ScriptExecutor;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;

public class ScriptLauncher {
    private Environment environment;
    private IProject project;
    private ScriptExecutor executor;
    private Set<ExecutionResponseListener> listeners = new HashSet<ExecutionResponseListener>();
    private Integer timeout = null;

    public ScriptLauncher(Environment environment, IProject project) throws ScriptNotFoundException {
        this.environment = environment;
        this.project = project;
        this.environment.setUp(project);
    }

    public void addResponseListener(ExecutionResponseListener listener) {
        this.listeners.add(listener);
    }

    public void removeResponseListener(ExecutionResponseListener listener) {
        this.listeners.remove(listener);
    }

    public void launch(String argument) throws IOException, CoreException, InterruptedException {
        this.launch(argument, new String[0]);
    }

    public void launch(String argument, String param) throws IOException, CoreException, InterruptedException {
        this.launch(argument, new String[]{param});
    }

    protected ProcessBuilder prepare(String argument, String ... params) throws IOException, InterruptedException, CoreException {
        ProcessBuilder cmd = this.environment.getCommand();
        cmd.command().add(argument);
        cmd.command().addAll(Arrays.asList(params));
        this.executor = new ScriptExecutor();
        if (this.timeout != null) {
            this.executor.setTimeout(this.timeout.intValue());
        }
        Logger.debug("Setting executor working directory to " + this.project.getLocation().toOSString());
        cmd.directory(new File(this.project.getLocation().toOSString()));
        for (ExecutionResponseListener listener : this.listeners) {
            this.executor.addResponseListener(listener);
        }
        HashMap<String, String> env = new HashMap<String, String>(System.getenv());
        PHPLaunchUtilities.appendExecutableToPathEnv(env, (File)new File(cmd.command().get(0)).getParentFile());
        PHPLaunchUtilities.appendLibrarySearchPathEnv(env, (File)new File(cmd.command().get(0)).getParentFile());
        cmd.environment().putAll(env);
        return cmd;
    }

    public void launch(String argument, String ... params) throws IOException, InterruptedException, CoreException {
        ProcessBuilder cmd = this.prepare(argument, params);
        this.executor.execute(cmd);
    }

    protected Set<ExecutionResponseListener> getListeners() {
        return this.listeners;
    }

    public void abort() {
        try {
            this.executor.abort();
        }
        catch (DebugException e) {
            Logger.debug(e.getMessage());
        }
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}

