/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.preferences.presentation.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.Property;

public class NavigateHandler
extends AbstractHandler {
    protected IStructuredSelection targetSelection;
    protected Viewer viewer;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.viewer != null) {
            this.viewer.setSelection((ISelection)this.targetSelection, true);
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        Object selection;
        IEvaluationContext evaluationContext2 = (IEvaluationContext)evaluationContext;
        Object activeEditorPart = evaluationContext2.getVariable("activeEditor");
        if (activeEditorPart instanceof IViewerProvider) {
            this.viewer = ((IViewerProvider)activeEditorPart).getViewer();
        }
        if ((selection = evaluationContext2.getVariable("selection")) instanceof IStructuredSelection) {
            this.updateSelection((IStructuredSelection)selection);
        }
        this.setBaseEnabled(this.viewer != null && !this.targetSelection.isEmpty());
    }

    public boolean updateSelection(IStructuredSelection selection) {
        ArrayList<Object> targets = new ArrayList<Object>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceNode ancestor;
            Object object = objectArray[n2];
            if (object instanceof PreferenceNode) {
                PreferenceNode preferenceNode = (PreferenceNode)object;
                ancestor = preferenceNode.getAncestor();
                if (ancestor != null) {
                    targets.add(ancestor);
                }
            } else if (object instanceof Property) {
                Property property = (Property)object;
                ancestor = property.getAncestor();
                if (ancestor != null) {
                    targets.add(ancestor);
                }
            } else if (object instanceof IWrapperItemProvider) {
                IWrapperItemProvider wrapperItemProvider = (IWrapperItemProvider)object;
                targets.add(wrapperItemProvider.getValue());
            } else if (object instanceof ItemProvider) {
                ItemProvider itemProvider = (ItemProvider)object;
                for (Object child : itemProvider.getChildren()) {
                    if (!(child instanceof IWrapperItemProvider)) continue;
                    targets.add(((IWrapperItemProvider)child).getValue());
                }
            }
            ++n2;
        }
        this.targetSelection = new StructuredSelection(targets);
        return !this.targetSelection.isEmpty();
    }
}

