/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.assist;

import java.io.IOException;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.assist.SourceTemplateContextType;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

public class WikiTextTemplateAccess {
    private static final String CUSTOM_TEMPLATES_KEY = "org.eclipse.mylyn.wikitext.ui.customtemplates";
    private static WikiTextTemplateAccess instance;
    private ContextTypeRegistry registry;
    private TemplateStore templateStore;

    public static WikiTextTemplateAccess getInstance() {
        if (instance == null) {
            instance = new WikiTextTemplateAccess();
        }
        return instance;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.registry == null) {
            if (WikiTextUiPlugin.getDefault() != null) {
                ContributionContextTypeRegistry contributionRegistry = new ContributionContextTypeRegistry();
                contributionRegistry.addContextType("org.eclipse.mylyn.wikitext.ui.editor");
                this.registry = contributionRegistry;
            } else {
                ContextTypeRegistry contextTypeRegistry = new ContextTypeRegistry();
                contextTypeRegistry.addContextType((TemplateContextType)new SourceTemplateContextType());
                this.registry = contextTypeRegistry;
            }
        }
        return this.registry;
    }

    public TemplateStore getTemplateStore() {
        if (this.templateStore == null && WikiTextUiPlugin.getDefault() != null) {
            this.templateStore = new ContributionTemplateStore(this.getContextTypeRegistry(), WikiTextUiPlugin.getDefault().getPreferenceStore(), CUSTOM_TEMPLATES_KEY);
            try {
                this.templateStore.load();
            }
            catch (IOException e) {
                WikiTextUiPlugin.getDefault().log(e);
            }
        }
        return this.templateStore;
    }
}

