/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.tagmatcher;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.jst.jsf.common.sets.AxiomaticSet;
import org.eclipse.jst.jsf.common.sets.ConcreteAxiomaticSet;
import org.eclipse.jst.jsf.common.sets.NodeSet;
import org.eclipse.jst.jsf.core.tagmatcher.EvaluationException;
import org.eclipse.jst.jsf.core.tagmatcher.TagMatchingAlgorithm;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathMatchingAlgorithm
extends TagMatchingAlgorithm {
    private final boolean _isStrictMatching;
    private final XPath _xpath;
    private XPathExpression _compiledExpr;

    public XPathMatchingAlgorithm(String expression) {
        this(expression, false);
    }

    public XPathMatchingAlgorithm(String expression, boolean isStrictMatching) {
        super(expression);
        this._isStrictMatching = isStrictMatching;
        this._xpath = XPathFactory.newInstance().newXPath();
    }

    @Override
    protected AxiomaticSet doEvaluate(Node target) {
        try {
            NodeList nodeList = (NodeList)this._compiledExpr.evaluate(target, XPathConstants.NODESET);
            return new NodeSet(nodeList);
        }
        catch (XPathExpressionException xpam) {
            if (this._isStrictMatching) {
                throw new EvaluationException(xpam);
            }
            return new ConcreteAxiomaticSet();
        }
    }

    @Override
    protected void doInitialize() throws XPathExpressionException {
        this._compiledExpr = this._xpath.compile(this._expression);
    }
}

