/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jpt.common.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.common.core.resource.java.NestableAnnotationDefinition;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jaxb.core.JaxbResourceModelProvider;
import org.eclipse.jpt.jaxb.core.JaxbWorkspace;
import org.eclipse.jpt.jaxb.core.context.java.DefaultJavaAttributeMappingDefinition;
import org.eclipse.jpt.jaxb.core.context.java.JavaAttributeMappingDefinition;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformConfig;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformDefinition;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatformManager;

public abstract class AbstractJaxbPlatformDefinition
implements JaxbPlatformDefinition {
    private Map<String, String> javaToSchemaTypes;
    private AnnotationDefinition[] annotationDefinitions;
    private NestableAnnotationDefinition[] nestableAnnotationDefinitions;
    private JaxbResourceModelProvider[] resourceModelProviders;
    private ArrayList<DefaultJavaAttributeMappingDefinition> defaultJavaAttributeMappingDefinitions;
    private ArrayList<JavaAttributeMappingDefinition> specifiedJavaAttributeMappingDefinitions;

    protected AbstractJaxbPlatformDefinition() {
    }

    @Override
    public final JaxbPlatformConfig getConfig() {
        return this.getJaxbPlatformConfig(this.getConfigId());
    }

    protected abstract String getConfigId();

    private JaxbPlatformConfig getJaxbPlatformConfig(String platformID) {
        JaxbPlatformManager jaxbPlatformManager = this.getJaxbPlatformManager();
        return jaxbPlatformManager == null ? null : jaxbPlatformManager.getJaxbPlatformConfig(platformID);
    }

    private JaxbPlatformManager getJaxbPlatformManager() {
        JaxbWorkspace jaxbWorkspace = this.getJaxbWorkspace();
        return jaxbWorkspace == null ? null : jaxbWorkspace.getJaxbPlatformManager();
    }

    private JaxbWorkspace getJaxbWorkspace() {
        return (JaxbWorkspace)ResourcesPlugin.getWorkspace().getAdapter(JaxbWorkspace.class);
    }

    @Override
    public String getSchemaTypeMapping(String javaTypeName) {
        if (this.javaToSchemaTypes == null) {
            this.javaToSchemaTypes = new HashMap<String, String>();
            this.javaToSchemaTypes.putAll(this.buildJavaToSchemaTypes());
        }
        return this.javaToSchemaTypes.get(javaTypeName);
    }

    protected Map<String, String> buildJavaToSchemaTypes() {
        return Collections.emptyMap();
    }

    @Override
    public AnnotationDefinition[] getAnnotationDefinitions() {
        if (this.annotationDefinitions == null) {
            this.annotationDefinitions = this.buildAnnotationDefinitions();
        }
        return this.annotationDefinitions;
    }

    protected abstract AnnotationDefinition[] buildAnnotationDefinitions();

    @Override
    public NestableAnnotationDefinition[] getNestableAnnotationDefinitions() {
        if (this.nestableAnnotationDefinitions == null) {
            this.nestableAnnotationDefinitions = this.buildNestableAnnotationDefinitions();
        }
        return this.nestableAnnotationDefinitions;
    }

    protected abstract NestableAnnotationDefinition[] buildNestableAnnotationDefinitions();

    @Override
    public ListIterable<JaxbResourceModelProvider> getResourceModelProviders() {
        return IterableTools.listIterable((Object[])this.getResourceModelProviders_());
    }

    protected synchronized JaxbResourceModelProvider[] getResourceModelProviders_() {
        if (this.resourceModelProviders == null) {
            this.resourceModelProviders = this.buildResourceModelProviders();
        }
        return this.resourceModelProviders;
    }

    protected abstract JaxbResourceModelProvider[] buildResourceModelProviders();

    @Override
    public synchronized Iterable<DefaultJavaAttributeMappingDefinition> getDefaultJavaAttributeMappingDefinitions() {
        if (this.defaultJavaAttributeMappingDefinitions == null) {
            this.defaultJavaAttributeMappingDefinitions = this.buildDefaultJavaAttributeMappingDefinitions();
        }
        return this.defaultJavaAttributeMappingDefinitions;
    }

    protected ArrayList<DefaultJavaAttributeMappingDefinition> buildDefaultJavaAttributeMappingDefinitions() {
        ArrayList<DefaultJavaAttributeMappingDefinition> definitions = new ArrayList<DefaultJavaAttributeMappingDefinition>();
        this.addDefaultJavaAttributeMappingDefinitionsTo(definitions);
        return definitions;
    }

    protected abstract void addDefaultJavaAttributeMappingDefinitionsTo(ArrayList<DefaultJavaAttributeMappingDefinition> var1);

    @Override
    public synchronized Iterable<JavaAttributeMappingDefinition> getSpecifiedJavaAttributeMappingDefinitions() {
        if (this.specifiedJavaAttributeMappingDefinitions == null) {
            this.specifiedJavaAttributeMappingDefinitions = this.buildSpecifiedJavaAttributeMappingDefinitions();
        }
        return this.specifiedJavaAttributeMappingDefinitions;
    }

    protected ArrayList<JavaAttributeMappingDefinition> buildSpecifiedJavaAttributeMappingDefinitions() {
        ArrayList<JavaAttributeMappingDefinition> definitions = new ArrayList<JavaAttributeMappingDefinition>();
        this.addSpecifiedJavaAttributeMappingDefinitionsTo(definitions);
        return definitions;
    }

    protected abstract void addSpecifiedJavaAttributeMappingDefinitionsTo(ArrayList<JavaAttributeMappingDefinition> var1);
}

