/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util.emf.workbench;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.internal.util.emf.workbench.EMFWorkbenchContextFactory;
import org.eclipse.jem.internal.util.emf.workbench.ProjectResourceSetImpl;
import org.eclipse.jem.internal.util.emf.workbench.WorkspaceResourceHandler;
import org.eclipse.jem.internal.util.emf.workbench.nls.EMFWorkbenchResourceHandler;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ResourceSetWorkbenchSynchronizer;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverter;
import org.eclipse.jem.util.emf.workbench.WorkbenchURIConverterImpl;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;

public class EMFWorkbenchContextBase {
    protected IProject project;
    protected ProjectResourceSet resourceSet;

    public EMFWorkbenchContextBase(IProject aProject) {
        if (aProject == null) {
            throw new IllegalArgumentException(EMFWorkbenchResourceHandler.getString("EMFWorkbenchContextBase_ERROR_1"));
        }
        this.project = aProject;
    }

    public void dispose() {
        if (this.resourceSet != null) {
            this.resourceSet.release();
        }
        this.resourceSet = null;
        this.project = null;
    }

    public IProject getProject() {
        return this.project;
    }

    public ProjectResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = this.createResourceSet();
            this.initializeResourceSet(this.resourceSet);
        }
        return this.resourceSet;
    }

    public boolean hasResourceSet() {
        return this.resourceSet != null;
    }

    protected void initializeResourceSet(ProjectResourceSet aResourceSet) {
        this.createResourceSetSynchronizer(aResourceSet);
        aResourceSet.setURIConverter(this.createURIConverter(aResourceSet));
        aResourceSet.add(new WorkspaceResourceHandler());
        JEMUtilPlugin.getDefault().addExtendedResourceHandlers(aResourceSet);
    }

    protected ProjectResourceSet createResourceSet() {
        if (this.project == null) {
            throw new IllegalStateException(EMFWorkbenchResourceHandler.getString("EMFWorkbenchContextBase_ERROR_2"));
        }
        return new ProjectResourceSetImpl(this.project);
    }

    protected WorkbenchURIConverter createURIConverter(ProjectResourceSet aResourceSet) {
        return new WorkbenchURIConverterImpl((IContainer)this.getProject(), aResourceSet.getSynchronizer());
    }

    protected ResourceSetWorkbenchSynchronizer createResourceSetSynchronizer(ProjectResourceSet aResourceSet) {
        return EMFWorkbenchContextFactory.INSTANCE.createSynchronizer(aResourceSet, this.getProject());
    }

    public void deleteResource(Resource aResource) throws CoreException {
        if (aResource != null) {
            this.deleteFile(aResource);
        }
    }

    public void deleteFile(Resource resource) {
        throw new UnsupportedOperationException(EMFWorkbenchResourceHandler.getString("EMFWorkbenchContextBase_ERROR_0"));
    }

    public Resource getResource(URI uri) {
        return this.resourceSet.getResource(uri, true);
    }
}

