/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.launch.runtime;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe2.language.factory.Mwe2ExecutionEngine;
import org.eclipse.emf.mwe2.language.mwe2.Module;
import org.eclipse.emf.mwe2.language.mwe2.Mwe2Package;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflow;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowContext;
import org.eclipse.xtext.mwe.RuntimeResourceSetInitializer;
import org.eclipse.xtext.mwe.UriFilter;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;

public class Mwe2Runner {
    @Inject
    private RuntimeResourceSetInitializer initializer;
    @Inject
    private Mwe2ExecutionEngine engine;
    @Inject
    private Provider<IWorkflowContext> ctxProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    public void run(URI createURI, Map<String, String> params) {
        this.run(createURI, params, (IWorkflowContext)this.ctxProvider.get());
    }

    public void run(URI createURI, Map<String, String> params, IWorkflowContext ctx) {
        EObject eObject;
        ResourceSet resourceSet = this.getConfiguredResourceSet();
        Resource resource = resourceSet.getResource(createURI, true);
        if (resource != null && !resource.getContents().isEmpty() && (eObject = (EObject)resource.getContents().get(0)) instanceof Module) {
            this.run((Module)eObject, params, ctx);
            return;
        }
        throw new IllegalArgumentException("Couldn't load module from URI " + String.valueOf(createURI));
    }

    public void run(String moduleName, Map<String, String> params) {
        this.run(moduleName, params, (IWorkflowContext)this.ctxProvider.get());
    }

    public void run(String moduleName, Map<String, String> params, IWorkflowContext ctx) {
        Module module = this.findModule(moduleName);
        if (module == null) {
            throw new IllegalStateException("Couldn't find module " + moduleName);
        }
        this.run(module, params, ctx);
    }

    public void run(Module module, Map<String, String> params, IWorkflowContext ctx) {
        if (module == null) {
            throw new IllegalArgumentException("No module provided ");
        }
        EcoreUtil.resolveAll((EObject)module);
        if (!module.eResource().getErrors().isEmpty()) {
            throw new IllegalStateException(module.eResource().getErrors().toString());
        }
        Map<QualifiedName, Object> actualParams = this.getRealParams(params);
        Object object = null;
        try {
            object = this.engine.create(module, actualParams);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Problems instantiating module " + module.getCanonicalName() + ": " + e.getMessage(), e);
        }
        if (!(object instanceof IWorkflow)) {
            throw new IllegalArgumentException("The root element must be of type IWorkflow but was '" + String.valueOf(object.getClass()) + "'.");
        }
        try {
            ((IWorkflow)object).run(ctx);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Problems running workflow " + module.getCanonicalName() + ": " + e.getMessage(), e);
        }
    }

    protected Map<QualifiedName, Object> getRealParams(Map<String, String> params) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<String, String> param : params.entrySet()) {
            map.put(this.qualifiedNameConverter.toQualifiedName(param.getKey()), param.getValue());
        }
        return map;
    }

    protected Module findModule(String moduleName) {
        System.err.println(moduleName);
        ResourceSet resourceSet = this.getConfiguredResourceSet();
        IResourceDescriptions descriptions = this.initializer.getDescriptions(resourceSet);
        for (IResourceDescription desc : descriptions.getAllResourceDescriptions()) {
            Iterable iterable = desc.getExportedObjects(Mwe2Package.Literals.MODULE, this.qualifiedNameConverter.toQualifiedName(moduleName), false);
            Iterator iterator = iterable.iterator();
            if (!iterator.hasNext()) continue;
            IEObjectDescription objDesc = (IEObjectDescription)iterator.next();
            return (Module)resourceSet.getEObject(objDesc.getEObjectURI(), true);
        }
        return null;
    }

    protected ResourceSet getConfiguredResourceSet() {
        ResourceSet resourceSet = this.initializer.getInitializedResourceSet(this.getPathes(), new UriFilter(){

            public boolean matches(URI uri) {
                return "mwe2".equalsIgnoreCase(uri.fileExtension());
            }
        });
        return resourceSet;
    }

    protected List<String> getPathes() {
        return this.initializer.getClassPathEntries();
    }

    public void setEngine(Mwe2ExecutionEngine engine) {
        this.engine = engine;
    }

    public void setInitializer(RuntimeResourceSetInitializer initializer) {
        this.initializer = initializer;
    }
}

