/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.ui;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.etypes.Annotation;
import org.eclipse.emf.cdo.etypes.ModelElement;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.Delivery;
import org.eclipse.emf.cdo.lm.Drop;
import org.eclipse.emf.cdo.lm.FixedBaseline;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.reviews.DeliveryReview;
import org.eclipse.emf.cdo.lm.reviews.DropReview;
import org.eclipse.emf.cdo.lm.reviews.Review;
import org.eclipse.emf.cdo.lm.reviews.ReviewsPackage;
import org.eclipse.emf.cdo.lm.reviews.impl.ReviewStatemachine;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public final class ClientReviewStatemachine<REVIEW extends Review>
extends ReviewStatemachine.Client<REVIEW> {
    public static final ClientReviewStatemachine<DeliveryReview> DELIVERIES = new ClientReviewStatemachine(false);
    public static final ClientReviewStatemachine<DropReview> DROPS = new ClientReviewStatemachine(true);

    private ClientReviewStatemachine(boolean dropReviews) {
        super(dropReviews);
    }

    protected void handleMergeFromSource(REVIEW review, ReviewStatemachine.MergeFromSourceResult result) {
        DeliveryReview deliveryReview = (DeliveryReview)review;
        deliveryReview.setSourceCommit(result.sourceCommit);
    }

    protected void handleRebaseToTarget(REVIEW review, ReviewStatemachine.RebaseToTargetResult result) {
        DeliveryReview deliveryReview = (DeliveryReview)review;
        deliveryReview.setRebaseCount(deliveryReview.getRebaseCount() + 1);
        deliveryReview.setBranch(result.rebaseBranch);
        if (result.isSuccess()) {
            deliveryReview.setTargetCommit(result.targetCommit);
        }
        EList contents = review.getStream().getContents();
        contents.move(0, (Object)deliveryReview);
    }

    protected void handleSubmit(REVIEW review, FixedBaseline submitResult) {
        Stream stream = review.getStream();
        if (review instanceof DeliveryReview) {
            DeliveryReview deliveryReview = (DeliveryReview)review;
            Change change = deliveryReview.getSourceChange();
            Delivery delivery = (Delivery)submitResult;
            delivery.setChange(change);
            stream.insertContent((Baseline)delivery);
            Annotation annotation = ReviewsPackage.getAnnotation((ModelElement)delivery, (boolean)true);
            annotation.getContents().add((Object)deliveryReview);
            this.setCommitComment((CDOObject)review, "Add delivery '" + delivery.getName() + "' to stream '" + stream.getName() + "'");
        } else if (review instanceof DropReview) {
            DropReview dropReview = (DropReview)review;
            Drop drop = (Drop)submitResult;
            drop = (Drop)dropReview.cdoView().getObject((EObject)drop);
            Annotation annotation = ReviewsPackage.getAnnotation((ModelElement)drop, (boolean)true);
            annotation.getContents().add((Object)dropReview);
            this.setCommitComment((CDOObject)review, "Add drop '" + drop.getName() + "' to stream '" + stream.getName() + "'");
        }
    }

    protected void handleAbandon(REVIEW review) {
    }

    protected void handleRestore(REVIEW review) {
    }

    protected void handleDelete(REVIEW review) {
    }

    public static <REVIEW extends Review> ClientReviewStatemachine<REVIEW> of(REVIEW review) {
        if (review instanceof DeliveryReview) {
            return DELIVERIES;
        }
        if (review instanceof DropReview) {
            return DROPS;
        }
        return null;
    }
}

