/*
 * Copyright (c) 2010-2012, 2019 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.internal.common.branch;

import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;

import java.text.MessageFormat;

/**
 * @author Eike Stepper
 */
public class CDOBranchPointRangeImpl implements CDOBranchPointRange
{
  private final CDOBranchPoint startPoint;

  private final CDOBranchPoint endPoint;

  public CDOBranchPointRangeImpl(CDOBranchPoint startPoint, CDOBranchPoint endPoint)
  {
    this.startPoint = startPoint;
    this.endPoint = endPoint;
  }

  @Override
  public CDOBranchPoint getStartPoint()
  {
    return startPoint;
  }

  @Override
  public CDOBranchPoint getEndPoint()
  {
    return endPoint;
  }

  @Override
  public String toString()
  {
    return MessageFormat.format("Range[{0}, {1}]", startPoint, endPoint); //$NON-NLS-1$
  }
}
