/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.shadows;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.shadows.AbstractDropShadowBorder;
import org.eclipse.pde.api.tools.annotations.NoExtend;
import org.eclipse.pde.api.tools.annotations.NoInstantiate;
import org.eclipse.pde.api.tools.annotations.NoReference;

@NoExtend
@NoReference
@NoInstantiate
public class RectangleDropShadowBorder
extends AbstractDropShadowBorder {
    private static final int DEFAULT_CORNER_START_RADIUS = 4;
    private int cornerStartRadius;

    public RectangleDropShadowBorder() {
        this(4);
    }

    public RectangleDropShadowBorder(int cornerRadius) {
        this.cornerStartRadius = cornerRadius;
    }

    @Override
    protected void paintDropShadow(Graphics graphics, Rectangle shadowRect, int size) {
        int bottomXStart = shadowRect.x + 1;
        int bottomY = shadowRect.y + 1 + shadowRect.height;
        int bottomXEnd = shadowRect.x + shadowRect.width + 1 - this.cornerStartRadius;
        int rightX = shadowRect.x + shadowRect.width + 1;
        int rightYStart = shadowRect.y + 1;
        int rightYEnd = shadowRect.y + shadowRect.height + 1 - this.cornerStartRadius;
        int cornerDiameter = 2 * this.cornerStartRadius;
        int i = 0;
        while (i <= size) {
            double progress = (double)i / (double)size;
            graphics.setAlpha(this.calcAlphaValue(progress));
            graphics.drawLine(bottomXStart, bottomY, bottomXEnd, bottomY);
            graphics.drawLine(rightX, rightYStart, rightX, rightYEnd);
            graphics.drawArc(rightX - cornerDiameter, bottomY - cornerDiameter, cornerDiameter, cornerDiameter, 270, 90);
            ++bottomXStart;
            ++bottomY;
            ++rightX;
            ++rightYStart;
            cornerDiameter += 2;
            ++i;
        }
    }

    @Override
    protected void paintHalo(Graphics graphics, Rectangle shadowRect, int size) {
        Rectangle r = shadowRect.getCopy();
        int cornerRadius = this.cornerStartRadius;
        int i = 0;
        while (i < size) {
            double progress = (double)i / (double)size;
            graphics.setAlpha(this.calcAlphaValue(progress));
            graphics.drawRoundRectangle(r, cornerRadius, cornerRadius);
            cornerRadius += 2;
            r.expand(1, 1);
            ++i;
        }
    }

    public void setCornerRadius(int cornerRadius) {
        this.cornerStartRadius = cornerRadius;
    }
}

