/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionAdapter;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.modelbase.sql.query.QueryDeleteStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryInsertStatement;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceFormat;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserInternalException;
import org.eclipse.datatools.sqltools.parsers.sql.postparse.PostParseProcessorConfiguration;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParseResult;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserManager;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserManagerProvider;
import org.eclipse.datatools.sqltools.parsers.sql.query.postparse.DataTypeResolver;
import org.eclipse.datatools.sqltools.parsers.sql.query.postparse.TableReferenceResolver;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.model.DeleteHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.IOmitSchemaInfo;
import org.eclipse.datatools.sqltools.sqlbuilder.model.InsertHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.UpdateHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.VendorHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.RSCCoreUIUtil;
import org.eclipse.datatools.sqltools.sqlbuilder.util.SQLDBUtil;
import org.eclipse.datatools.sqltools.sqlbuilder.util.WorkbenchUtility;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SQLDomainModel {
    private AdapterFactoryEditingDomain editingDomain;
    private Connection jdbcConnection;
    private QueryStatement sqlStatement;
    private VendorHelper vendorHelper;
    private IFile sqlFileResource;
    private IProject project;
    private ISQLEditorConnectionInfo connectionInfo;
    private IOmitSchemaInfo _omitSchemaInfo;
    private String currentSchema;
    private String initialSource;
    private boolean unmatchedSource;
    private Database database;
    private DatabaseDefinition dbDefinition;
    private boolean lDirty = false;
    private String improperStatement;
    private SQLQuerySourceFormat sqlSourceFormat = null;
    private List postParseProcessorList = null;
    private static Hashtable templateSQLTable = new Hashtable(6);
    private String editorText;

    public SQLDomainModel() {
    }

    public SQLDomainModel(QueryStatement aStatement, Database aDatabase) {
        this.sqlStatement = aStatement;
        this.database = aDatabase;
    }

    public AdapterFactoryEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setEditingDomain(AdapterFactoryEditingDomain anEditingDomain) {
        this.editingDomain = anEditingDomain;
    }

    public AdapterFactory getAdapterFactory() {
        return SQLBuilderPlugin.getAdapterFactory();
    }

    public AdapterFactoryContentProvider createContentProvider() {
        return new SQLAdapterFactoryContentProvider(this.getAdapterFactory());
    }

    public AdapterFactoryLabelProvider createLabelProvider() {
        return new AdapterFactoryLabelProvider(this.getAdapterFactory());
    }

    public QueryStatement getSQLStatement() {
        return this.sqlStatement;
    }

    public void setSQLStatement(QueryStatement query) {
        this.sqlStatement = query;
    }

    public String getTemplateSQL(int type) {
        String templateSQL;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{type});
        }
        if ((templateSQL = (String)templateSQLTable.get(type)) == null && (templateSQL = StatementHelper.getTemplateSQL((int)type)) != null) {
            templateSQLTable.put(type, templateSQL.trim());
        }
        return (String)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)templateSQL);
    }

    private static void initTemplateSQLTable() {
        int[] nArray = new int[6];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        int[] stmtTypes = nArray;
        int i = 0;
        while (i < stmtTypes.length) {
            int stmtType = stmtTypes[i];
            String templateSQL = StatementHelper.getTemplateSQL((int)stmtType);
            if (templateSQL != null) {
                templateSQLTable.put(stmtType, templateSQL.trim());
            }
            ++i;
        }
    }

    public String getTemplateSQLForCurrentStatement() {
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(null);
        String templateSQL = null;
        int type = StatementHelper.getStatementType((QueryStatement)this.sqlStatement);
        if (type != -1) {
            templateSQL = this.getTemplateSQL(type);
        }
        return (String)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)templateSQL);
    }

    public void replaceStatementContents(QueryStatement newStmt) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{newStmt});
        }
        String name = this.sqlStatement.getName();
        String label = this.sqlStatement.getLabel();
        if (this.sqlStatement instanceof QueryInsertStatement && newStmt instanceof QueryInsertStatement) {
            InsertHelper.replaceStatementContents((QueryInsertStatement)this.sqlStatement, (QueryInsertStatement)newStmt);
        } else if (this.sqlStatement instanceof QueryUpdateStatement && newStmt instanceof QueryUpdateStatement) {
            UpdateHelper.replaceStatementContents((QueryUpdateStatement)this.sqlStatement, (QueryUpdateStatement)newStmt);
        } else if (this.sqlStatement instanceof QueryDeleteStatement && newStmt instanceof QueryDeleteStatement) {
            DeleteHelper.replaceStatementContents((QueryDeleteStatement)this.sqlStatement, (QueryDeleteStatement)newStmt);
        } else if (this.sqlStatement instanceof QuerySelectStatement && newStmt instanceof QuerySelectStatement) {
            SelectHelper.replaceStatementContents((QuerySelectStatement)this.sqlStatement, (QuerySelectStatement)newStmt);
        }
        newStmt.setName(name);
        newStmt.setLabel(label);
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public void clearStatementToTemplate() {
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(null);
        int type = StatementHelper.getStatementType((QueryStatement)this.sqlStatement);
        QueryStatement newStmt = StatementHelper.createQueryStatement((int)type, (String)"");
        newStmt.getSourceInfo().setSqlFormat(this.getSqlSourceFormat());
        this.replaceStatementContents(newStmt);
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public void setDirty(boolean dirty) {
        this.lDirty = dirty;
    }

    public boolean isDirty() {
        return this.lDirty;
    }

    public IFile getIFile() {
        return this.sqlFileResource;
    }

    public void setIFile(IFile aFileResource) {
        this.sqlFileResource = aFileResource;
    }

    public static void showParseErrors(Exception exception) {
        String pluginId = SQLBuilderPlugin.getPlugin().getBundle().getSymbolicName();
        if (exception instanceof SQLParserException) {
            String title = Messages._UI_PARSE_ERROR_ENCOUNTERED;
            String message = ((SQLParserException)((Object)exception)).getMessage();
            Status status = new Status(4, pluginId, 0, message, null);
            ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message, (IStatus)status);
        } else {
            boolean cfr_ignored_0 = exception instanceof SQLParserInternalException;
        }
    }

    public boolean openFileResource(IFile fileResource) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{fileResource});
        }
        this.sqlFileResource = fileResource;
        String statementName = fileResource.getName();
        String strSQL = this.readContentsToString(fileResource);
        return this.initializeFromString(strSQL, statementName);
    }

    public boolean openStorageResource(IStorage storageResource) throws Exception {
        int k;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{storageResource});
        }
        String strSQL = null;
        InputStream iStream = storageResource.getContents();
        int iSize = iStream.available();
        byte[] buff = new byte[iSize];
        ByteArrayOutputStream oStream = new ByteArrayOutputStream(iSize);
        while ((k = iStream.read(buff)) != -1) {
            ((OutputStream)oStream).write(buff, 0, k);
        }
        strSQL = ((Object)oStream).toString();
        iStream.close();
        ((OutputStream)oStream).close();
        return this.initializeFromString(strSQL, storageResource.getName());
    }

    public boolean initializeFromString(String strSQL, String statementName) {
        boolean retval;
        block7: {
            retval = true;
            this.initialSource = strSQL = strSQL.trim();
            try {
                this.sqlStatement = this.parse(strSQL);
            }
            catch (Exception e) {
                if (templateSQLTable == null || templateSQLTable.size() < 6) {
                    SQLDomainModel.initTemplateSQLTable();
                }
                if (templateSQLTable.containsValue(strSQL = strSQL.replaceAll("\r", ""))) break block7;
                retval = false;
                this.unmatchedSource = true;
                SQLBuilderPlugin.getPlugin().getLogger().writeLog((Throwable)e);
            }
        }
        if (this.sqlStatement != null) {
            if (statementName != null) {
                this.sqlStatement.setName(statementName);
            }
        } else {
            this.sqlStatement = this.getDefaultStatementFromSQL(strSQL, statementName);
            if (this.isSQLStatementTypeKeyword(strSQL)) {
                this.unmatchedSource = false;
            }
        }
        return SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(retval);
    }

    public boolean initializeFromType(int statementType) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{Integer.toString(statementType)});
        }
        boolean retval = true;
        if (templateSQLTable == null || templateSQLTable.size() < 6) {
            SQLDomainModel.initTemplateSQLTable();
        }
        this.sqlStatement = this.getDefaultStatementFromStatementType(statementType, null);
        return SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(retval);
    }

    protected String readContentsToString(IFile fileResource) {
        return WorkbenchUtility.readFileContentsToString(fileResource, true);
    }

    public Connection getConnection() {
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(null);
        try {
            ConnectionInfo connInfo;
            Database db;
            if (this.jdbcConnection == null && (db = this.getDatabase()) instanceof ICatalogObject) {
                this.jdbcConnection = ((ICatalogObject)db).getConnection();
            }
            if (this.jdbcConnection != null && this.jdbcConnection.isClosed() && (connInfo = ((ConnectionAdapter)this.jdbcConnection).getConnectionInfo()) != null) {
                this.jdbcConnection = connInfo.getSharedConnection();
            }
        }
        catch (Exception e) {
            SQLBuilderPlugin.getPlugin().getLogger().writeLog((Throwable)e);
            this.jdbcConnection = null;
        }
        return (Connection)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)this.jdbcConnection);
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public DatabaseDefinition getDatabaseDefinition() {
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(null);
        if (this.dbDefinition == null) {
            Database db;
            if (this.connectionInfo != null) {
                this.dbDefinition = SQLDBUtil.getDatabaseDefinition(this.connectionInfo);
            }
            if (this.dbDefinition == null && (db = this.getDatabase()) != null) {
                this.dbDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(db);
            }
        }
        return (DatabaseDefinition)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)this.dbDefinition);
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject proj) {
        this.project = proj;
    }

    public ISQLEditorConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public void setConnectionInfo(ISQLEditorConnectionInfo info) {
        this.connectionInfo = info;
    }

    public void setOmitSchemaInfo(IOmitSchemaInfo info) {
        this._omitSchemaInfo = info;
    }

    public IOmitSchemaInfo getOmitSchemaInfo() {
        return this._omitSchemaInfo;
    }

    public boolean save() {
        boolean retStatus;
        block27: {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(null);
            retStatus = false;
            IFile fileResource = this.getIFile();
            String encoding = ResourcesPlugin.getEncoding();
            if (fileResource != null) {
                try {
                    encoding = fileResource.getCharset();
                }
                catch (CoreException coreException) {}
                ByteArrayInputStream inpStream = null;
                try {
                    try {
                        if (fileResource.exists()) {
                            StringBuffer sb = new StringBuffer();
                            if (this.isProper()) {
                                sb.append(this.getSQLStatement().getSQL());
                            } else {
                                String improperStmt = this.getImproperStatement();
                                if (improperStmt != null) {
                                    sb.append(improperStmt);
                                } else {
                                    sb.append(this.getSQLStatement().getSQL());
                                }
                            }
                            inpStream = new ByteArrayInputStream(sb.toString().getBytes(encoding));
                            fileResource.setContents((InputStream)inpStream, true, false, null);
                            fileResource.setCharset(encoding, (IProgressMonitor)new NullProgressMonitor());
                        } else {
                            File sysFile = fileResource.getLocation().toFile();
                            if (!sysFile.exists()) {
                                StringBuffer sb = new StringBuffer();
                                if (this.editorText != null && !this.editorText.equals("")) {
                                    sb.append(this.editorText);
                                } else {
                                    sb.append(this.getSQLStatement().getSQL());
                                }
                                inpStream = new ByteArrayInputStream(sb.toString().getBytes(encoding));
                                fileResource.create((InputStream)inpStream, false, null);
                                fileResource.setCharset(encoding, (IProgressMonitor)new NullProgressMonitor());
                            }
                        }
                        retStatus = true;
                    }
                    catch (Exception e) {
                        SQLBuilderPlugin.getPlugin().getLogger().writeLog((Throwable)e);
                        Display disp = Display.getCurrent();
                        if (disp != null) {
                            Shell shell = disp.getActiveShell();
                            String title = Messages.Editor_error_save_title;
                            String msg = Messages.Editor_error_save_message;
                            msg = this.getIFile() != null && this.getIFile().isReadOnly() ? String.valueOf(msg) + Messages.Editor_error_save_readonly + " " + this.getIFile().getFullPath() : String.valueOf(msg) + Messages.Editor_error_save_failed + " " + this.getIFile().getFullPath();
                            MessageDialog.openError((Shell)shell, (String)title, (String)msg);
                        }
                        retStatus = false;
                        if (inpStream != null) {
                            try {
                                inpStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block27;
                    }
                }
                catch (Throwable throwable) {
                    if (inpStream != null) {
                        try {
                            inpStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (inpStream != null) {
                    try {
                        inpStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(retStatus);
    }

    public void setEditorText(String text) {
        this.editorText = text;
    }

    public VendorHelper getVendor() {
        if (this.vendorHelper == null) {
            this.vendorHelper = new VendorHelper(this.getDatabase());
        }
        return this.vendorHelper;
    }

    public VendorHelper resetVendor(Database db) {
        if (db != null) {
            this.vendorHelper = new VendorHelper(db);
            return this.vendorHelper;
        }
        return null;
    }

    public boolean isProper() {
        return this.improperStatement == null;
    }

    public void setImproperStatement(String improperStmt) {
        this.improperStatement = improperStmt;
    }

    public String getImproperStatement() {
        return this.improperStatement;
    }

    public void setCurrentSchema() {
        this.currentSchema = this._omitSchemaInfo.getUseAUIDAsCurrentSchema() ? this.getUserName() : this._omitSchemaInfo.getCurrentSchema();
        SQLQuerySourceFormat sourceFormat = this.getSqlSourceFormat();
        if (this._omitSchemaInfo.getOmitCurrentSchema()) {
            sourceFormat.setOmitSchema(this.currentSchema);
        } else {
            sourceFormat.setOmitSchema(null);
        }
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public QueryStatement getDefaultStatementFromSQL(String sql, String statementName) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{sql, statementName});
        }
        Object statement = null;
        statement = (sql = sql.toUpperCase()).startsWith("INSERT") ? StatementHelper.createInsertStatement((String)statementName) : (sql.startsWith("UPDATE") ? StatementHelper.createUpdateStatement((String)statementName) : (sql.startsWith("DELETE") ? StatementHelper.createDeleteStatement((String)statementName) : (sql.indexOf("UNION") >= 0 ? StatementHelper.createQueryCombinedStatement((String)statementName) : (sql.startsWith("SELECT") && sql.indexOf("UNION") < 0 ? StatementHelper.createQuerySelectStatement((String)statementName) : (sql.startsWith("WITH") ? StatementHelper.createWithStatement((String)statementName) : StatementHelper.createQuerySelectStatement((String)statementName))))));
        statement.getSourceInfo().setSqlFormat(this.getSqlSourceFormat());
        return (QueryStatement)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(statement);
    }

    public QueryStatement getDefaultStatementFromStatementType(int statementType, String statementName) {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{Integer.toString(statementType), statementName});
        }
        Object statement = null;
        statement = statementType == 1 ? StatementHelper.createInsertStatement((String)statementName) : (statementType == 2 ? StatementHelper.createUpdateStatement((String)statementName) : (statementType == 3 ? StatementHelper.createDeleteStatement((String)statementName) : (statementType == 4 ? StatementHelper.createQueryCombinedStatement((String)statementName) : (statementType == 0 ? StatementHelper.createQuerySelectStatement((String)statementName) : (statementType == 5 ? StatementHelper.createWithStatement((String)statementName) : StatementHelper.createQuerySelectStatement((String)statementName))))));
        statement.getSourceInfo().setSqlFormat(this.getSqlSourceFormat());
        return (QueryStatement)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(statement);
    }

    protected boolean isSQLStatementTypeKeyword(String sql) {
        return (sql = sql.toUpperCase()).equals("SELECT") || sql.equals("INSERT") || sql.equals("UPDATE") || sql.equals("DELETE");
    }

    protected SQLQueryParserManager getParserManager() {
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(null);
        SQLQueryParserManager parserManager = null;
        DatabaseDefinition dbDef = this.getDatabaseDefinition();
        if (dbDef != null) {
            String dbProduct = this.getDatabaseDefinition().getProduct();
            String dbVersion = this.getDatabaseDefinition().getVersion();
            parserManager = SQLQueryParserManagerProvider.getInstance().getParserManager(dbProduct, dbVersion);
            PostParseProcessorConfiguration p3config = this.getPostParseProcessorConfiguration();
            SQLQuerySourceFormat srcFormat = this.getSqlSourceFormat();
            parserManager.setSourceFormat(srcFormat);
            parserManager.configPostParseProcessors(p3config);
        }
        return (SQLQueryParserManager)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(parserManager);
    }

    public QueryStatement parse(String sqlStr) throws SQLParserException, SQLParserInternalException {
        SQLQueryParseResult parseResult;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{sqlStr});
        }
        QueryStatement parsedStatement = null;
        SQLQueryParserManager parserManager = this.getParserManager();
        if (parserManager != null && (parseResult = parserManager.parseQuery(sqlStr)) != null) {
            parsedStatement = parseResult.getQueryStatement();
        }
        return (QueryStatement)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(parsedStatement);
    }

    public QueryStatement parse(String sqlStr, List errorList) throws SQLParserException, SQLParserInternalException {
        SQLQueryParseResult parseResult;
        SQLQueryParserManager parserManager;
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{sqlStr, errorList});
        }
        QueryStatement parsedStatement = null;
        if (errorList != null && (parserManager = this.getParserManager()) != null && (parseResult = parserManager.parseQuery(sqlStr)) != null) {
            errorList.clear();
            errorList.addAll(parseResult.getErrorList());
            parsedStatement = parseResult.getQueryStatement();
        }
        return (QueryStatement)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(parsedStatement);
    }

    public QueryStatement parse(String sqlStr, boolean createObjectTree) throws SQLParserException, SQLParserInternalException {
        if (SQLBuilderPlugin.getPlugin().getLogger().isTracing()) {
            SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(new Object[]{sqlStr, createObjectTree});
        }
        QueryStatement parsedStatement = null;
        if (createObjectTree) {
            parsedStatement = this.parse(sqlStr);
        } else {
            SQLQueryParserManager parserManager = this.getParserManager();
            if (parserManager != null) {
                parsedStatement = parserManager.checkSyntax(sqlStr);
            }
        }
        return (QueryStatement)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)parsedStatement);
    }

    public SQLQuerySourceFormat getSqlSourceFormat() {
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(null);
        if (this.sqlSourceFormat == null) {
            VendorHelper vendorHelper;
            this.sqlSourceFormat = SQLQuerySourceFormat.copyDefaultFormat();
            String curSchema = this.getCurrentSchema();
            if (this._omitSchemaInfo.getOmitCurrentSchema()) {
                this.sqlSourceFormat.setOmitSchema(curSchema);
            } else if (!this._omitSchemaInfo.getOmitCurrentSchema()) {
                this.sqlSourceFormat.setOmitSchema(null);
            }
            DatabaseDefinition dbDef = this.getDatabaseDefinition();
            if (dbDef != null && dbDef.getIdentifierQuoteString() != null && dbDef.getIdentifierQuoteString().length() == 1) {
                this.sqlSourceFormat.setDelimitedIdentifierQuote(dbDef.getIdentifierQuoteString().charAt(0));
            }
            Database db = this.getDatabase();
            ISQLEditorConnectionInfo connInfo = this.getConnectionInfo();
            if (db == null && connInfo != null) {
                db = connInfo.getDatabase();
            }
            if (db != null && (vendorHelper = new VendorHelper(db)).isOracle()) {
                this.sqlSourceFormat.setGenerateAsKeywordForTableCorrID(false);
            }
        }
        return (SQLQuerySourceFormat)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)this.sqlSourceFormat);
    }

    public void setSqlSourceFormat(SQLQuerySourceFormat sqlSourceFormat) {
        this.sqlSourceFormat = sqlSourceFormat;
    }

    public String getSQLForExecution() {
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(null);
        SQLQuerySourceFormat srcFormat = this.sqlStatement.getSourceInfo().getSqlFormat();
        if (this._omitSchemaInfo.getOmitCurrentSchema()) {
            srcFormat.setOmitSchema(null);
        }
        String source = this.sqlStatement.getSQL();
        this.resetOmitSchemaToCurrentSchema();
        return (String)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)source);
    }

    public void resetOmitSchemaToCurrentSchema() {
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(null);
        SQLQuerySourceFormat srcFormat = this.getSqlSourceFormat();
        if (this._omitSchemaInfo.getOmitCurrentSchema()) {
            srcFormat.setOmitSchema(this.currentSchema);
        }
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit(null);
    }

    public List getPostParseProcessorList() {
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(null);
        if (this.postParseProcessorList == null) {
            this.postParseProcessorList = new ArrayList();
            Database db = this.getDatabase();
            String currentSchemaName = this.getCurrentSchema();
            TableReferenceResolver tableReferenceResolver = new TableReferenceResolver(db, currentSchemaName);
            DataTypeResolver dataTypeResolver = new DataTypeResolver();
            this.postParseProcessorList.add(tableReferenceResolver);
            this.postParseProcessorList.add(dataTypeResolver);
        }
        return (List)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)this.postParseProcessorList);
    }

    public String getInitialSource() {
        return this.initialSource;
    }

    public boolean isUnmatchedSource() {
        return this.unmatchedSource;
    }

    public void setUnmatchedSource(boolean unmatched) {
        this.unmatchedSource = unmatched;
    }

    public String getDefaultSchema() {
        String defaultSchema = null;
        if (this.connectionInfo != null && (defaultSchema = this.connectionInfo.getDefaultSchemaName()) == null) {
            defaultSchema = this.getUserName();
        }
        return (String)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)defaultSchema);
    }

    public String getUserName() {
        Properties props;
        Object objUserName;
        IConnectionProfile cp;
        String userName = "";
        if (this.connectionInfo != null && (cp = this.connectionInfo.getConnectionProfile()) != null && (objUserName = (props = cp.getBaseProperties()).get("org.eclipse.datatools.connectivity.db.username")) instanceof String && (userName = (String)objUserName) == null) {
            userName = "";
        }
        return userName;
    }

    public PostParseProcessorConfiguration getPostParseProcessorConfiguration() {
        SQLBuilderPlugin.getPlugin().getLogger().writeTraceEntry(null);
        Database db = this.getDatabase();
        String currentSchemaName = this.getCurrentSchema();
        PostParseProcessorConfiguration p3config = new PostParseProcessorConfiguration(db, currentSchemaName);
        return (PostParseProcessorConfiguration)SQLBuilderPlugin.getPlugin().getLogger().writeTraceExit((Object)p3config);
    }

    public DatabaseIdentifier getDatabaseIdentifier() {
        String profileName = this.connectionInfo.getConnectionProfileName();
        String dbName = this.connectionInfo.getDatabaseName();
        return new DatabaseIdentifier(profileName, dbName);
    }

    public boolean isConnected() {
        return this.connectionInfo.isConnected();
    }

    public void setInitialSource(String strSQL) {
        this.initialSource = strSQL;
    }

    public boolean getIsStatementTypeSupported(int stmtType) {
        boolean isSupported = false;
        switch (stmtType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                isSupported = true;
            }
        }
        return isSupported;
    }

    private class SQLAdapterFactoryContentProvider
    extends AdapterFactoryContentProvider {
        public SQLAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public void notifyChanged(Notification notification) {
            if (this.viewer == null) {
                return;
            }
            Object obj = notification.getNotifier();
            if (obj == null || !(obj instanceof EObject) || !RSCCoreUIUtil.chkIfEObjectsMatched((EObject)obj, (EObject)SQLDomainModel.this.getSQLStatement(), true)) {
                return;
            }
            super.notifyChanged(notification);
        }
    }
}

