/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db.DbProfilePropertyPage;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.db.DbProfileWizardPage;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceEditorPage;
import org.eclipse.datatools.connectivity.oda.profile.internal.OdaConnectionProfile;
import org.eclipse.datatools.connectivity.ui.wizards.ExtensibleProfileDetailsPropertyPage;
import org.eclipse.datatools.connectivity.ui.wizards.ProfilePropertyPage;
import org.eclipse.swt.widgets.Composite;

public class DbProfilePageWrapper {
    static final String DEFAULT_MESSAGE = Messages.dbProfilePage_defaultPageMessage;
    private ProfilePropertyPage m_wrappedPage;

    protected DbProfilePageWrapper(DbProfileWizardPage page, ProfilePropertyPage wrappedPage) {
        assert (page != null && wrappedPage != null);
        this.m_wrappedPage = wrappedPage;
        this.init();
    }

    protected DbProfilePageWrapper(DbProfilePropertyPage page, ProfilePropertyPage wrappedPage) {
        assert (page != null && wrappedPage != null);
        wrappedPage.setContainer(page.getContainer());
        this.m_wrappedPage = wrappedPage;
        this.init();
    }

    private void init() {
    }

    protected void createCustomControl(Composite parent, boolean isReadOnly) throws OdaException {
        this.m_wrappedPage.createControl(parent, isReadOnly);
    }

    protected void initCustomControl(Properties profileProps) {
    }

    boolean hasDefaultPropertyPage() {
        return this.m_wrappedPage instanceof DataSourceEditorPage;
    }

    boolean isValid() {
        return this.m_wrappedPage.isValid() && this.isPageComplete();
    }

    private boolean isPageComplete() {
        if (this.m_wrappedPage instanceof ExtensibleProfileDetailsPropertyPage) {
            return ((ExtensibleProfileDetailsPropertyPage)this.m_wrappedPage).determinePageCompletion();
        }
        return true;
    }

    String getErrorMessage() {
        return this.m_wrappedPage.getErrorMessage();
    }

    public boolean performOk() {
        return this.m_wrappedPage.performOk();
    }

    Properties collectCustomProperties(boolean isSessionEditable) {
        if (isSessionEditable && this.isPageComplete()) {
            this.performOk();
        }
        return this.getWrappedPageProfile().getBaseProperties();
    }

    private IConnectionProfile getWrappedPageProfile() {
        return this.m_wrappedPage.getConnectionProfile();
    }

    String getDbProfileProviderId() {
        IConnectionProfile connProfile = this.getWrappedPageProfile();
        if (connProfile instanceof OdaConnectionProfile) {
            return ((OdaConnectionProfile)connProfile).getDirectProviderId();
        }
        return null;
    }

    void cleanup() {
        IConnectionProfile propertyPageProfile = this.getWrappedPageProfile();
        if (propertyPageProfile instanceof OdaConnectionProfile) {
            ((OdaConnectionProfile)propertyPageProfile).close();
        }
    }
}

