/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.converter;

import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.params.converter.ArgumentConversionException;
import org.junit.jupiter.params.converter.ArgumentConverter;
import org.junit.jupiter.params.support.FieldContext;
import org.junit.platform.commons.support.conversion.ConversionException;
import org.junit.platform.commons.support.conversion.ConversionSupport;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="5.0")
public class DefaultArgumentConverter
implements ArgumentConverter {
    public static final DefaultArgumentConverter INSTANCE = new DefaultArgumentConverter();

    private DefaultArgumentConverter() {
    }

    @Override
    public final @Nullable Object convert(@Nullable Object source, ParameterContext context) {
        Class<?> targetType = context.getParameter().getType();
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(context.getDeclaringExecutable().getDeclaringClass());
        return this.convert(source, targetType, classLoader);
    }

    @Override
    public final @Nullable Object convert(@Nullable Object source, FieldContext context) throws ArgumentConversionException {
        Class<?> targetType = context.getField().getType();
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(context.getField().getDeclaringClass());
        return this.convert(source, targetType, classLoader);
    }

    public final @Nullable Object convert(@Nullable Object source, Class<?> targetType, ClassLoader classLoader) {
        if (source == null) {
            if (targetType.isPrimitive()) {
                throw new ArgumentConversionException("Cannot convert null to primitive value of type " + targetType.getTypeName());
            }
            return null;
        }
        if (ReflectionUtils.isAssignableTo((Object)source, targetType)) {
            return source;
        }
        if (source instanceof String) {
            String string = (String)source;
            try {
                return this.convert(string, targetType, classLoader);
            }
            catch (ConversionException ex) {
                throw new ArgumentConversionException(ex.getMessage(), ex);
            }
        }
        throw new ArgumentConversionException("No built-in converter for source type %s and target type %s".formatted(source.getClass().getTypeName(), targetType.getTypeName()));
    }

    @Nullable Object convert(@Nullable String source, Class<?> targetType, ClassLoader classLoader) {
        return ConversionSupport.convert((String)source, targetType, (ClassLoader)classLoader);
    }
}

