/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.label;

import com.google.inject.Inject;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.label.DeclarativeLabelProvider;
import org.eclipse.xtext.ui.label.DefaultEditorImageUtil;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.Pair;

public class DefaultDescriptionLabelProvider
extends DeclarativeLabelProvider {
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private DefaultEditorImageUtil imageUtil;

    public Object image(IEObjectDescription element) {
        return this.doGetImage(element.getEClass());
    }

    public Object image(IResourceDescription element) {
        return this.getImageForURI(element.getURI());
    }

    public Object image(IReferenceDescription referenceDescription) {
        if (referenceDescription.getSourceEObjectUri() != null) {
            return this.getImageForURI(referenceDescription.getSourceEObjectUri());
        }
        return null;
    }

    protected Object getImageForURI(URI uri) {
        String fileName = uri.lastSegment();
        return this.imageUtil.getDefaultEditorImageDescriptor(fileName);
    }

    public Object text(IEObjectDescription element) {
        return String.valueOf(element.getQualifiedName()) + " - " + element.getEClass().getName();
    }

    public Object text(IResourceDescription element) {
        Iterator<Pair<IStorage, IProject>> storages = this.storage2UriMapper.getStorages(element.getURI()).iterator();
        if (storages.hasNext()) {
            IStorage storage = (IStorage)storages.next().getFirst();
            return storage.getFullPath().toString();
        }
        return null;
    }

    public Object text(IReferenceDescription referenceDescription) {
        return "<unnamed>";
    }
}

