/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.navigation;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.OpenAndLinkWithEditorHelper;
import org.eclipse.xtext.ide.editor.navigation.INavigatable;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.xbase.lib.Procedures;

@Singleton
public class NavigationService {
    @Inject
    private IURIEditorOpener uriEditorOpener;

    public void open(OpenEvent openEvent) {
        this.open(openEvent, true);
    }

    public void open(OpenEvent openEvent, boolean select) {
        ISelection selection = openEvent.getSelection();
        if (selection instanceof IStructuredSelection) {
            for (Object element : (IStructuredSelection)selection) {
                if (!(element instanceof INavigatable)) continue;
                this.open((INavigatable)element, select);
            }
        }
    }

    public void open(INavigatable navigatable) {
        this.open(navigatable, true);
    }

    public void open(INavigatable navigatable, boolean select) {
        if (navigatable != null) {
            Object navigatableElement = navigatable.getNavigationElement();
            if (navigatableElement instanceof IReferenceDescription) {
                IReferenceDescription referenceDescription = (IReferenceDescription)navigatableElement;
                this.uriEditorOpener.open(referenceDescription.getSourceEObjectUri(), referenceDescription.getEReference(), referenceDescription.getIndexInList(), select);
            } else if (navigatableElement instanceof IEObjectDescription) {
                this.uriEditorOpener.open(((IEObjectDescription)navigatableElement).getEObjectURI(), select);
            } else if (navigatableElement instanceof IResourceDescription) {
                this.uriEditorOpener.open(((IResourceDescription)navigatableElement).getURI(), select);
            } else if (navigatableElement instanceof INavigatable) {
                this.open((INavigatable)navigatableElement, select);
            }
        }
    }

    public OpenAndLinkWithEditorHelper installNavigationSupport(StructuredViewer viewer) {
        return this.installNavigationSupport(viewer, true);
    }

    public OpenAndLinkWithEditorHelper installNavigationSupport(StructuredViewer viewer, boolean select) {
        return this.installNavigationSupport(viewer, (Procedures.Procedure1<? super OpenEvent>)((Procedures.Procedure1)openEvent -> this.open((OpenEvent)openEvent, select)));
    }

    public OpenAndLinkWithEditorHelper installNavigationSupport(final StructuredViewer viewer, final Procedures.Procedure1<? super OpenEvent> opener) {
        return new OpenAndLinkWithEditorHelper(viewer){

            protected void activate(ISelection selection) {
                int currentMode = OpenStrategy.getOpenMethod();
                try {
                    OpenStrategy.setOpenMethod((int)0);
                    opener.apply((Object)new OpenEvent((Viewer)viewer, selection));
                }
                finally {
                    OpenStrategy.setOpenMethod((int)currentMode);
                }
            }

            protected void open(ISelection selection, boolean activate) {
                opener.apply((Object)new OpenEvent((Viewer)viewer, selection));
            }

            protected void linkToEditor(ISelection selection) {
            }
        };
    }
}

