/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.xml;

import java.io.PrintWriter;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.wb.internal.core.utils.xml.AbstractDocumentObject;
import org.eclipse.wb.internal.core.utils.xml.DocumentElement;

public final class DocumentAttribute
extends AbstractDocumentObject {
    private DocumentElement m_enclosingElement;
    private int m_nameOffset;
    private int m_nameLength;
    private int m_valueOffset;
    private int m_valueLength;
    private String m_name;
    private String m_value;

    public void setEnclosingElement(DocumentElement element) {
        this.m_enclosingElement = element;
    }

    public DocumentElement getEnclosingElement() {
        return this.m_enclosingElement;
    }

    public void setNameOffset(int offset) {
        this.m_nameOffset = offset;
    }

    public int getNameOffset() {
        return this.m_nameOffset;
    }

    public void setNameLength(int length) {
        this.m_nameLength = length;
    }

    public int getNameLength() {
        return this.m_nameLength;
    }

    public void setValueOffset(int offset) {
        this.m_valueOffset = offset;
    }

    public int getValueOffset() {
        return this.m_valueOffset;
    }

    public void setValueLength(int length) {
        this.m_valueLength = length;
    }

    public int getValueLength() {
        return this.m_valueLength;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public void setValue(String value) {
        String oldValue = this.m_value;
        value = this.getModel() != null && !"UTF-8".equals(this.getModel().getCharset()) ? DocumentAttribute.escapeXml(value) : DocumentAttribute.escapeXml0(value);
        this.m_value = value;
        if (this.m_enclosingElement != null) {
            this.firePropertyChanged(this.m_enclosingElement, this.m_name, oldValue, this.m_value);
        }
    }

    public String getValue() {
        return this.m_value;
    }

    private static String escapeXml(String s) {
        s = DocumentAttribute.escapeXml0(s);
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                result.append("&#" + Integer.toString(c) + ";");
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    private static String escapeXml0(String s) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c < ' ') {
                result.append("&#" + Integer.toString(c) + ";");
            } else if (c == '&') {
                result.append("&amp;");
            } else if (c == '\'') {
                result.append("&apos;");
            } else if (c == '\"') {
                result.append("&quot;");
            } else if (c == '<') {
                result.append("&lt;");
            } else if (c == '>') {
                result.append("&gt;");
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }

    public void write(PrintWriter writer) {
        writer.print(this.m_name);
        writer.print("=");
        writer.print('\"');
        writer.print(StringEscapeUtils.escapeXml10((String)this.m_value));
        writer.print('\"');
    }
}

