/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.requests;

import org.eclipse.wb.gef.core.requests.AbstractCreateRequest;
import org.eclipse.wb.gef.core.requests.ICreationFactory;

public class CreateRequest
extends AbstractCreateRequest {
    private static final int SNAP_TO = 16;
    private final ICreationFactory m_factory;
    private Object m_newObject;
    private Object m_selectObject;
    private int m_flags = 0;

    public CreateRequest(ICreationFactory factory) {
        super("create child");
        this.m_factory = factory;
    }

    public Object getNewObject() {
        if (this.m_newObject == null) {
            this.m_selectObject = this.m_newObject = this.m_factory.getNewObject();
        }
        return this.m_newObject;
    }

    public Object getSelectObject() {
        return this.m_selectObject;
    }

    public void setSelectObject(Object object) {
        this.m_selectObject = object;
    }

    public void setSnapToEnabled(boolean value) {
        this.m_flags = value ? this.m_flags | 0x10 : this.m_flags & 0xFFFFFFEF;
    }

    public boolean isSnapToEnabled() {
        return (this.m_flags & 0x10) != 0;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("CreateRequest(type=");
        buffer.append(this.getType());
        buffer.append(", flags=");
        buffer.append(this.m_flags);
        buffer.append(", location=");
        buffer.append(this.getLocation());
        buffer.append(", size=");
        buffer.append(this.getSize());
        buffer.append(", factory=");
        buffer.append(this.m_factory);
        if (this.m_factory != null) {
            buffer.append("[object=");
            buffer.append(CreateRequest.safeToString(this.m_factory.getNewObject()));
            buffer.append("]");
        }
        buffer.append(")");
        return buffer.toString();
    }

    protected static String safeToString(Object o) {
        try {
            return o == null ? null : o.toString();
        }
        catch (Throwable e) {
            return "<exception>";
        }
    }
}

