/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.description.tool;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ReconnectionKind implements Enumerator
{
    RECONNECT_TARGET_LITERAL(0, "RECONNECT_TARGET", "RECONNECT_TARGET"),
    RECONNECT_SOURCE_LITERAL(1, "RECONNECT_SOURCE", "RECONNECT_SOURCE"),
    RECONNECT_BOTH_LITERAL(2, "RECONNECT_BOTH", "RECONNECT_BOTH");

    public static final int RECONNECT_TARGET = 0;
    public static final int RECONNECT_SOURCE = 1;
    public static final int RECONNECT_BOTH = 2;
    private static final ReconnectionKind[] VALUES_ARRAY;
    public static final List<ReconnectionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ReconnectionKind[]{RECONNECT_TARGET_LITERAL, RECONNECT_SOURCE_LITERAL, RECONNECT_BOTH_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ReconnectionKind get(String literal) {
        ReconnectionKind[] reconnectionKindArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            ReconnectionKind result = reconnectionKindArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static ReconnectionKind getByName(String name) {
        ReconnectionKind[] reconnectionKindArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            ReconnectionKind result = reconnectionKindArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static ReconnectionKind get(int value) {
        switch (value) {
            case 0: {
                return RECONNECT_TARGET_LITERAL;
            }
            case 1: {
                return RECONNECT_SOURCE_LITERAL;
            }
            case 2: {
                return RECONNECT_BOTH_LITERAL;
            }
        }
        return null;
    }

    private ReconnectionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

