/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.asm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;

public class EclipseLinkClassReader
extends ClassReader {
    public EclipseLinkClassReader(InputStream stream) throws IOException {
        this(EclipseLinkClassReader.getStream(stream));
    }

    public EclipseLinkClassReader(byte[] classFile) {
        this(classFile, 0, classFile.length);
    }

    public EclipseLinkClassReader(byte[] classFileBuffer, int classFileOffset, int classFileLength) {
        super(classFileBuffer, classFileOffset, false);
    }

    private static byte[] getStream(InputStream inputStream) throws IOException {
        int bytesRead;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] data = new byte[4096];
        while ((bytesRead = inputStream.read(data, 0, data.length)) != -1) {
            outputStream.write(data, 0, bytesRead);
        }
        outputStream.flush();
        return outputStream.toByteArray();
    }
}

