/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.debug.core.adwp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.debug.core.adwp.ADWP;
import org.eclipse.m2m.atl.debug.core.adwp.ADWPCommand;
import org.eclipse.m2m.atl.debug.core.adwp.ObjectReference;
import org.eclipse.m2m.atl.debug.core.adwp.RemoteObjectReference;
import org.eclipse.m2m.atl.debug.core.adwp.Value;

public class ADWPDebugger
extends ADWP {
    private int msgId = 1;
    private List<ADWPCommand> nonAnswers = new ArrayList<ADWPCommand>();
    private List<ADWPCommand> answers = new ArrayList<ADWPCommand>();

    public ADWPDebugger(InputStream in, OutputStream out) {
        super(in, out);
    }

    public void sendCommand(int cmd, List<Value> args) {
        this.realSendCommand(cmd, args);
    }

    private void realSendCommand(int cmd, List<Value> args) {
        try {
            this.out.writeByte(cmd);
            this.out.writeByte(this.msgId++);
            this.out.writeInt(args.size());
            Iterator<Value> i = args.iterator();
            while (i.hasNext()) {
                this.writeValue(i.next());
            }
            this.out.flush();
        }
        catch (IOException ioe) {
            ATLLogger.log((Level)Level.SEVERE, (String)ioe.getLocalizedMessage(), (Throwable)ioe);
        }
    }

    public ADWPCommand readMessage() {
        ADWPCommand ret = null;
        ret = this.getMessageFrom(this.nonAnswers);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ADWPCommand getMessageFrom(List<ADWPCommand> list) {
        ADWPCommand ret = null;
        List<ADWPCommand> list2 = list;
        synchronized (list2) {
            if (list.size() == 0) {
                try {
                    do {
                        list.wait();
                    } while (list.size() == 0);
                }
                catch (InterruptedException ie) {
                    ATLLogger.log((Level)Level.SEVERE, (String)ie.getLocalizedMessage(), (Throwable)ie);
                }
            }
        }
        ret = list.remove(0);
        return ret;
    }

    public synchronized ADWPCommand requestMessage(int cmd, List<Value> args) {
        ADWPCommand ret = null;
        this.realSendCommand(cmd, args);
        ret = this.getMessageFrom(this.answers);
        return ret;
    }

    public synchronized Value request(int cmd, List<Value> args) {
        Value ret = null;
        ADWPCommand acmd = this.requestMessage(cmd, args);
        ret = acmd.getArgs().get(0);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.setName("ADWPDebugger receiver");
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                msgs = null;
                msg = null;
                type = this.in.readByte() & 255;
                ack = this.in.readByte() & 255;
                length = this.in.readInt();
                switch (type) {
                    case 103: {
                        msg = new ADWPCommand(type, ack, Collections.emptyList());
                        msgs = this.nonAnswers;
                        break;
                    }
                    case 101: {
                        msg = new ADWPCommand(type, ack, Arrays.asList(new Value[]{this.readValue()}));
                        msgs = this.answers;
                        break;
                    }
                    case 100: {
                        msg = new ADWPCommand(type, ack, Arrays.asList(new Value[]{this.readValue(), this.readValue(), this.readValue(), this.readValue(), this.readValue()}));
                        msgs = this.nonAnswers;
                        break;
                    }
                    case 102: {
                        args = new ArrayList<Value>();
                        i = 0;
                        while (i < length) {
                            args.add(this.readValue());
                            ++i;
                        }
                        msg = new ADWPCommand(type, ack, args);
                        msgs = this.answers;
                        break;
                    }
                }
                var6_7 = msgs;
                synchronized (var6_7) {
                    if (msgs != null) {
                        msgs.add(msg);
                        msgs.notifyAll();
                    }
                    continue;
                }
                break;
            }
        }
        catch (IOException var1_2) {
            return;
        }
        {
            ** while (true)
        }
    }

    @Override
    protected ObjectReference readObjectReference(int id) {
        return RemoteObjectReference.valueOf(this, id);
    }
}

