/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.wizard.atlfile;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.Messages;
import org.eclipse.m2m.atl.adt.ui.common.AbstractAtlSelection;
import org.eclipse.m2m.atl.adt.ui.common.AtlLibrarySelection;
import org.eclipse.m2m.atl.adt.ui.common.AtlModelSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class AtlFileScreen
extends WizardPage {
    public static final String UNIT_NAME = "NAME";
    public static final String UNIT_TYPE = "TYPE";
    public static final String TYPE_MODULE = "module";
    public static final String TYPE_REFINING_MODULE = "refining module";
    public static final String TYPE_QUERY = "query";
    public static final String TYPE_LIBRARY = "library";
    private Map<String, String> paths = new HashMap<String, String>();
    private Text textName;
    private Combo comboType;
    private Map<String, String> libraries = new LinkedHashMap<String, String>();
    private Map<String, String> input = new LinkedHashMap<String, String>();
    private Map<String, String> output = new LinkedHashMap<String, String>();
    private Button launchButton;
    private List inputList;
    private List outputList;
    private List libList;

    public AtlFileScreen(ISelection selection) {
        super(Messages.getString("AtlFileScreen.Page.Name"));
        this.setTitle(Messages.getString("AtlFileScreen.Title"));
        this.setDescription(Messages.getString("AtlFileScreen.Page.Description"));
        this.setImageDescriptor(AtlUIPlugin.getImageDescriptor("ATLWizard.png"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.initializeDialogUnits((Control)container);
        GridData data = new GridData(1808);
        container.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(3, false);
        container.setLayout((Layout)layout);
        new Label(container, 0).setText(Messages.getString("AtlFileScreen.MODULE_NAME"));
        this.textName = new Text(container, 2048);
        this.textName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AtlFileScreen.this.checkValid();
            }
        });
        data = new GridData(769);
        this.textName.setLayoutData((Object)data);
        this.addBlank(container);
        new Label(container, 0).setText(Messages.getString("AtlFileScreen.FILE_TYPE"));
        this.comboType = new Combo(container, 2056);
        this.comboType.setItems(new String[]{TYPE_MODULE, TYPE_REFINING_MODULE, TYPE_LIBRARY, TYPE_QUERY});
        this.comboType.setText(TYPE_MODULE);
        data = new GridData(769);
        this.comboType.setLayoutData((Object)data);
        this.addBlank(container);
        this.addSeparator(container);
        data = new GridData(1810);
        this.inputList = this.createModelControl(container, Messages.getString("AtlFileScreen.InputModels"), new AtlModelSelection(container.getShell(), Messages.getString("AtlFileScreen.InputModelCreation"), "IN", this.input, this.output, this.paths), data, this.input);
        this.outputList = this.createModelControl(container, Messages.getString("AtlFileScreen.OutputModels"), new AtlModelSelection(container.getShell(), Messages.getString("AtlFileScreen.OutputModelCreation"), "OUT", this.input, this.output, this.paths), data, this.output);
        this.addSeparator(container);
        data = new GridData(770);
        data.heightHint = 40;
        this.libList = this.createLibControl(container, new AtlLibrarySelection(container.getShell(), Messages.getString("AtlFileScreen.ATLLibraryCreation"), this.libraries), data);
        this.addSeparator(container);
        final Label launchLabel = new Label(container, 0);
        launchLabel.setText(Messages.getString("AtlFileScreen.CreateLc"));
        data = new GridData();
        data.verticalIndent = 5;
        data.horizontalSpan = 3;
        launchLabel.setLayoutData((Object)data);
        this.addBlank(container);
        this.launchButton = new Button(container, 32);
        this.launchButton.setText(Messages.getString("AtlFileScreen.CreateLcCheck"));
        this.launchButton.setSelection(true);
        this.launchButton.setLayoutData((Object)new GridData(2));
        this.comboType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean isLibrary = AtlFileScreen.this.comboType.getText().equals(AtlFileScreen.TYPE_LIBRARY);
                launchLabel.setEnabled(!isLibrary);
                AtlFileScreen.this.launchButton.setEnabled(!isLibrary);
                AtlFileScreen.this.launchButton.setSelection(!isLibrary);
                AtlFileScreen.this.checkValid();
            }
        });
        container.layout();
        this.setControl((Control)container);
    }

    private static String getEntryNameFromItem(String item) {
        return item.split(" : ")[0];
    }

    private void addBlank(Composite container) {
        Composite blank = new Composite(container, 0);
        blank.setLayout((Layout)new GridLayout());
    }

    private void addSeparator(Composite container) {
        Label separator = new Label(container, 258);
        GridData data = new GridData(768);
        data.horizontalSpan = 3;
        data.verticalIndent = 5;
        separator.setLayoutData((Object)data);
    }

    private List createModelControl(Composite parent, String entryLabel, final AbstractAtlSelection dialog, GridData listLayoutData, final Map<String, String> dataMap) {
        final Label typeLabel = new Label(parent, 0);
        GridData data = new GridData(2);
        data.verticalIndent = 5;
        typeLabel.setLayoutData((Object)data);
        typeLabel.setText(entryLabel);
        final List list = new List(parent, 2818);
        listLayoutData.verticalIndent = 5;
        list.setLayoutData((Object)listLayoutData);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        data = new GridData(2);
        data.verticalIndent = 5;
        composite.setLayoutData((Object)data);
        final Button addIn = this.createButton(composite, Messages.getString("AtlFileScreen.Add"));
        final Button removeIn = this.createButton(composite, Messages.getString("AtlFileScreen.Remove"));
        removeIn.setEnabled(false);
        addIn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                dialog.create();
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    if (result.length == 3) {
                        AtlFileScreen.this.paths.put(result[1].toString(), result[2].toString());
                        dataMap.put(result[0].toString(), result[1].toString());
                    } else if (result.length == 2) {
                        dataMap.put(result[0].toString(), result[1].toString());
                    }
                }
                AtlFileScreen.this.updateLists();
            }
        });
        removeIn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int[] indices = list.getSelectionIndices();
                int i = 0;
                while (i < indices.length) {
                    int j = indices[i];
                    String key = AtlFileScreen.getEntryNameFromItem(list.getItem(j));
                    AtlFileScreen.this.paths.remove(dataMap.get(key));
                    dataMap.remove(key);
                    ++i;
                }
                AtlFileScreen.this.updateLists();
                removeIn.setEnabled(list.getSelection().length > 0);
            }
        });
        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                removeIn.setEnabled(list.getSelection().length > 0);
            }
        });
        this.comboType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean hasModels = AtlFileScreen.this.comboType.getText().equals(AtlFileScreen.TYPE_MODULE) || AtlFileScreen.this.comboType.getText().equals(AtlFileScreen.TYPE_REFINING_MODULE);
                typeLabel.setEnabled(hasModels);
                list.setEnabled(hasModels);
                addIn.setEnabled(hasModels);
                removeIn.setEnabled(hasModels && list.getSelection().length > 0);
                AtlFileScreen.this.checkValid();
            }
        });
        return list;
    }

    private List createLibControl(Composite parent, final AbstractAtlSelection dialog, GridData listLayoutData) {
        final Label typeLabel = new Label(parent, 0);
        GridData data = new GridData(2);
        data.verticalIndent = 5;
        typeLabel.setLayoutData((Object)data);
        typeLabel.setText(Messages.getString("AtlFileScreen.ATLLibrary"));
        final List list = new List(parent, 2818);
        listLayoutData.verticalIndent = 5;
        list.setLayoutData((Object)listLayoutData);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        data = new GridData(2);
        data.verticalIndent = 5;
        composite.setLayoutData((Object)data);
        final Button addIn = this.createButton(composite, Messages.getString("AtlFileScreen.Add"));
        final Button removeIn = this.createButton(composite, Messages.getString("AtlFileScreen.Remove"));
        removeIn.setEnabled(false);
        addIn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                dialog.create();
                if (dialog.open() == 0) {
                    AtlFileScreen.this.libraries.put(dialog.getFirstResult().toString(), "");
                    AtlFileScreen.this.updateLists();
                }
            }
        });
        removeIn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int[] indices = list.getSelectionIndices();
                int i = 0;
                while (i < indices.length) {
                    int j = indices[i];
                    AtlFileScreen.this.libraries.remove(AtlFileScreen.getEntryNameFromItem(list.getItem(j)));
                    ++i;
                }
                AtlFileScreen.this.updateLists();
                removeIn.setEnabled(list.getSelection().length > 0);
            }
        });
        list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                removeIn.setEnabled(list.getSelection().length > 0);
            }
        });
        this.comboType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean hasModels = AtlFileScreen.this.comboType.getText().equals(AtlFileScreen.TYPE_MODULE) || AtlFileScreen.this.comboType.getText().equals(AtlFileScreen.TYPE_REFINING_MODULE);
                typeLabel.setEnabled(hasModels);
                list.setEnabled(hasModels);
                addIn.setEnabled(hasModels);
                removeIn.setEnabled(hasModels && list.getSelection().length > 0);
                AtlFileScreen.this.checkValid();
            }
        });
        return list;
    }

    private void updateLists() {
        StringBuffer item;
        String path;
        String metamodelName;
        this.inputList.removeAll();
        for (String modelName : this.input.keySet()) {
            metamodelName = this.input.get(modelName);
            path = this.paths.get(metamodelName);
            item = new StringBuffer(String.valueOf(modelName) + " : " + metamodelName);
            if (path != null) {
                item.append(" (" + path + ")");
            }
            this.inputList.add(item.toString());
        }
        this.outputList.removeAll();
        for (String modelName : this.output.keySet()) {
            metamodelName = this.output.get(modelName);
            path = this.paths.get(metamodelName);
            item = new StringBuffer(String.valueOf(modelName) + " : " + metamodelName);
            if (path != null) {
                item.append(" (" + path + ")");
            }
            this.outputList.add(item.toString());
        }
        this.libList.removeAll();
        Iterator<String> iterator = this.libraries.keySet().iterator();
        while (iterator.hasNext()) {
            this.libList.add(iterator.next());
        }
        this.checkValid();
    }

    private Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setAlignment(0x1000000);
        button.setText(text);
        button.setFont(parent.getFont());
        GridData data = new GridData();
        data.widthHint = this.convertHorizontalDLUsToPixels(61);
        button.setLayoutData((Object)data);
        return button;
    }

    public void setModuleName(String name) {
        this.textName.setText(name);
        this.textName.selectAll();
    }

    private void checkValid() {
        this.setPageComplete(this.checkUnitName() && this.checkModelsConsistancy());
    }

    private boolean checkUnitName() {
        String errorMessage = AbstractAtlSelection.checkIdentifier(this.textName.getText());
        this.setErrorMessage(errorMessage);
        return errorMessage == null;
    }

    private boolean checkModelsConsistancy() {
        if (this.comboType.getText().equals(TYPE_MODULE) || this.comboType.getText().equals(TYPE_REFINING_MODULE)) {
            if (this.input.isEmpty()) {
                this.setErrorMessage(Messages.getString("AtlFileWizard.INPUT_MODELS_ISSUE"));
                return false;
            }
            if (this.output.isEmpty()) {
                this.setErrorMessage(Messages.getString("AtlFileWizard.OUTPUT_MODELS_ISSUE"));
                return false;
            }
            if (this.comboType.getText().equals(TYPE_REFINING_MODULE)) {
                Iterator<String> iterator = this.input.values().iterator();
                while (iterator.hasNext()) {
                    if (!this.output.containsValue(iterator.next())) continue;
                    this.setErrorMessage(null);
                    return true;
                }
                this.setErrorMessage(Messages.getString("AtlFileWizard.REFINING_ISSUE"));
                return false;
            }
        }
        this.setErrorMessage(null);
        return true;
    }

    public boolean generateLaunchConfig() {
        return this.launchButton.getSelection();
    }

    protected Map<String, String> getPaths() {
        return this.paths;
    }

    public String getUnitName() {
        return this.textName.getText();
    }

    public String getUnitType() {
        return this.comboType.getText();
    }

    public Map<String, String> getLibraries() {
        return this.libraries;
    }

    public Map<String, String> getInput() {
        return this.input;
    }

    public Map<String, String> getOutput() {
        return this.output;
    }
}

