/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.mavenarchiver;

import org.apache.maven.plugin.MojoExecution;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.mavenarchiver.internal.JarArchiverConfigurator;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;

public class AbstractWTPArchiverConfigurator
extends JarArchiverConfigurator {
    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        if (WTPProjectsUtil.isM2eWtpDisabled(request.mavenProjectFacade(), monitor)) {
            return;
        }
        super.configure(request, monitor);
    }

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
        if (WTPProjectsUtil.isM2eWtpDisabled(event.getMavenProject(), monitor)) {
            return;
        }
        IMavenProjectFacade oldFacade = event.getOldMavenProject();
        IMavenProjectFacade newFacade = event.getMavenProject();
        if (oldFacade == null && newFacade == null) {
            return;
        }
        this.mavenProjectChanged(newFacade, oldFacade, true, monitor);
    }

    public AbstractBuildParticipant getBuildParticipant(IMavenProjectFacade projectFacade, MojoExecution execution, IPluginExecutionMetadata executionMetadata) {
        if (WTPProjectsUtil.isM2eWtpDisabled(projectFacade, (IProgressMonitor)new NullProgressMonitor())) {
            return null;
        }
        return super.getBuildParticipant(projectFacade, execution, executionMetadata);
    }

    protected boolean needsNewManifest(IFile manifest, IMavenProjectFacade oldFacade, IMavenProjectFacade newFacade) {
        return ModuleCoreNature.isFlexibleProject((IProject)newFacade.getProject()) && super.needsNewManifest(manifest, oldFacade, newFacade);
    }

    public boolean hasConfigurationChanged(IMavenProjectFacade newFacade, ILifecycleMappingConfiguration oldProjectConfiguration, MojoExecutionKey key, IProgressMonitor monitor) {
        return false;
    }
}

