/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.reference;

import java.io.Serializable;
import org.eclipse.jpt.common.utility.reference.ModifiableBooleanReference;

public class SimpleBooleanReference
implements ModifiableBooleanReference,
Cloneable,
Serializable {
    protected volatile boolean value;
    private static final long serialVersionUID = 1L;

    public SimpleBooleanReference(boolean value) {
        this.value = value;
    }

    public SimpleBooleanReference() {
        this(false);
    }

    @Override
    public boolean getValue() {
        return this.value;
    }

    @Override
    public boolean is(boolean v) {
        return this.value == v;
    }

    @Override
    public boolean isNot(boolean v) {
        return this.value ^ v;
    }

    @Override
    public boolean isTrue() {
        return this.value;
    }

    @Override
    public boolean isFalse() {
        return !this.value;
    }

    @Override
    public boolean setValue(boolean value) {
        boolean old = this.value;
        this.value = value;
        return old;
    }

    @Override
    public boolean flip() {
        this.value = !this.value;
        return this.value;
    }

    @Override
    public boolean and(boolean b) {
        return this.value &= b;
    }

    @Override
    public boolean or(boolean b) {
        return this.value |= b;
    }

    @Override
    public boolean xor(boolean b) {
        return this.value ^= b;
    }

    @Override
    public boolean setNot(boolean b) {
        return this.setValue(!b);
    }

    @Override
    public boolean setTrue() {
        return this.setValue(true);
    }

    @Override
    public boolean setFalse() {
        return this.setValue(false);
    }

    @Override
    public boolean commit(boolean newValue, boolean expectedValue) {
        if (this.value == expectedValue) {
            this.value = newValue;
            return true;
        }
        return false;
    }

    @Override
    public boolean swap(ModifiableBooleanReference other) {
        if (other == this) {
            return this.value;
        }
        boolean thisValue = this.value;
        boolean otherValue = other.getValue();
        if (thisValue != otherValue) {
            other.setValue(thisValue);
            this.value = otherValue;
        }
        return otherValue;
    }

    public SimpleBooleanReference clone() {
        try {
            return (SimpleBooleanReference)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return String.valueOf('[') + String.valueOf(this.value) + ']';
    }
}

