/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.merge.java.facade.jdom;

import java.util.Hashtable;
import org.eclipse.emf.codegen.CodeGenPlugin;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.JCompilationUnit;
import org.eclipse.emf.codegen.merge.java.facade.JField;
import org.eclipse.emf.codegen.merge.java.facade.JImport;
import org.eclipse.emf.codegen.merge.java.facade.JInitializer;
import org.eclipse.emf.codegen.merge.java.facade.JMethod;
import org.eclipse.emf.codegen.merge.java.facade.JNode;
import org.eclipse.emf.codegen.merge.java.facade.JPackage;
import org.eclipse.emf.codegen.merge.java.facade.JType;
import org.eclipse.emf.codegen.merge.java.facade.jdom.JDOMJCompilationUnit;
import org.eclipse.emf.codegen.merge.java.facade.jdom.JDOMJField;
import org.eclipse.emf.codegen.merge.java.facade.jdom.JDOMJImport;
import org.eclipse.emf.codegen.merge.java.facade.jdom.JDOMJInitializer;
import org.eclipse.emf.codegen.merge.java.facade.jdom.JDOMJMethod;
import org.eclipse.emf.codegen.merge.java.facade.jdom.JDOMJNode;
import org.eclipse.emf.codegen.merge.java.facade.jdom.JDOMJPackage;
import org.eclipse.emf.codegen.merge.java.facade.jdom.JDOMJType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMInitializer;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMPackage;
import org.eclipse.jdt.core.jdom.IDOMType;

public class JDOMFacadeHelper
extends FacadeHelper {
    protected DOMFactory jdomFactory;
    protected boolean forcedSourceCompatibility;

    public static IDOMNode getIDOMNode(JNode node) {
        return node instanceof JDOMJNode ? ((JDOMJNode)node).getWrappedObject() : null;
    }

    public JDOMFacadeHelper() {
        this.setForcedSourceCompatibility(true);
    }

    @Override
    public void reset() {
        this.jdomFactory = null;
        super.reset();
    }

    protected DOMFactory getJDOMFactory() {
        if (this.jdomFactory == null) {
            this.jdomFactory = new DOMFactory();
        }
        return this.jdomFactory;
    }

    public void setForcedSourceCompatibility(boolean forcedSourceCompatibility) {
        this.forcedSourceCompatibility = forcedSourceCompatibility;
    }

    public boolean isForcedSourceCompatibility() {
        return this.forcedSourceCompatibility;
    }

    protected void adjustSourceCompatibility(String value) {
        Hashtable map = JavaCore.getOptions();
        map.put("org.eclipse.jdt.core.compiler.source", value);
        JavaCore.setOptions((Hashtable)map);
    }

    @Override
    public JCompilationUnit createCompilationUnit(String name, String contents) {
        String sourceCompatibility = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        if (sourceCompatibility != null) {
            if ("1.4".compareTo(sourceCompatibility) < 0) {
                if (this.isForcedSourceCompatibility()) {
                    this.adjustSourceCompatibility("1.4");
                } else {
                    sourceCompatibility = null;
                    CodeGenPlugin.INSTANCE.log(CodeGenPlugin.INSTANCE.getString("_UI_JDOMInvalidSourceCompatibility_message"));
                }
            } else {
                sourceCompatibility = null;
            }
        }
        JDOMJCompilationUnit compilationUnit = (JDOMJCompilationUnit)this.convertToNode(this.getJDOMFactory().createCompilationUnit(contents, name));
        compilationUnit.setOriginalContent(contents);
        if (sourceCompatibility != null) {
            this.adjustSourceCompatibility(sourceCompatibility);
        }
        return compilationUnit;
    }

    @Override
    public String getOriginalContents(JCompilationUnit compilationUnit) {
        return ((JDOMJCompilationUnit)compilationUnit).getOriginalContent();
    }

    @Override
    protected JNode doConvertToNode(Object object) {
        JDOMJNode node = null;
        if (object instanceof IDOMCompilationUnit) {
            node = new JDOMJCompilationUnit((IDOMCompilationUnit)object);
        } else if (object instanceof IDOMField) {
            node = new JDOMJField((IDOMField)object);
        } else if (object instanceof IDOMImport) {
            node = new JDOMJImport((IDOMImport)object);
        } else if (object instanceof IDOMInitializer) {
            node = new JDOMJInitializer((IDOMInitializer)object);
        } else if (object instanceof IDOMMethod) {
            node = new JDOMJMethod((IDOMMethod)object);
        } else if (object instanceof IDOMPackage) {
            node = new JDOMJPackage((IDOMPackage)object);
        } else if (object instanceof IDOMType) {
            node = new JDOMJType((IDOMType)object);
        }
        if (node != null) {
            node.setFacadeHelper(this);
        }
        return node;
    }

    @Override
    public Object getContext(JNode node) {
        return null;
    }

    @Override
    public JNode cloneNode(Object context, JNode node) {
        String content = this.applyFormatRules(node.getContents());
        IDOMNode idomNode = null;
        if (node instanceof JCompilationUnit) {
            idomNode = JDOMFacadeHelper.getIDOMNode(this.createCompilationUnit(node.getName(), content));
        } else if (node instanceof JField) {
            idomNode = this.getJDOMFactory().createField(content);
        } else if (node instanceof JImport) {
            idomNode = this.getJDOMFactory().createImport(content);
        } else if (node instanceof JInitializer) {
            idomNode = this.getJDOMFactory().createInitializer(content);
        } else if (node instanceof JMethod) {
            idomNode = this.getJDOMFactory().createMethod(content);
        } else if (node instanceof JPackage) {
            idomNode = this.getJDOMFactory().createPackage(content);
        } else if (node instanceof JType) {
            idomNode = this.getJDOMFactory().createType(content);
        } else {
            IDOMNode originalIDOMNode = JDOMFacadeHelper.getIDOMNode(node);
            if (originalIDOMNode != null) {
                idomNode = (IDOMNode)originalIDOMNode.clone();
            }
        }
        return idomNode != null ? this.convertToNode(idomNode) : null;
    }

    @Override
    public boolean addChild(JNode node, JNode child) {
        if (child != null) {
            IDOMNode idomNode = JDOMFacadeHelper.getIDOMNode(node);
            IDOMNode idomChild = JDOMFacadeHelper.getIDOMNode(child);
            idomNode.addChild(idomChild);
            return true;
        }
        return false;
    }

    @Override
    public boolean insertSibling(JNode node, JNode sibiling, boolean before) {
        if (sibiling != null) {
            IDOMNode idomNode = JDOMFacadeHelper.getIDOMNode(node);
            if (!before) {
                idomNode = idomNode.getNextNode();
            }
            IDOMNode idomSibiling = JDOMFacadeHelper.getIDOMNode(sibiling);
            idomNode.insertSibling(idomSibiling);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(JNode node) {
        IDOMNode idomNode = JDOMFacadeHelper.getIDOMNode(node);
        IDOMNode parent = idomNode.getParent();
        if (parent != null) {
            idomNode.remove();
            return true;
        }
        return false;
    }

    @Override
    public JNode getFirstChild(JNode node) {
        IDOMNode idomNode = JDOMFacadeHelper.getIDOMNode(node);
        return this.convertToNode(idomNode.getFirstChild());
    }

    @Override
    public JNode getPrevious(JNode node) {
        IDOMNode idomNode = JDOMFacadeHelper.getIDOMNode(node);
        return this.convertToNode(idomNode.getPreviousNode());
    }

    @Override
    public JNode getNext(JNode node) {
        IDOMNode idomNode = JDOMFacadeHelper.getIDOMNode(node);
        return this.convertToNode(idomNode.getNextNode());
    }

    @Override
    public boolean fixInterfaceBrace() {
        return true;
    }

    @Override
    public boolean canYieldWrongJavadoc() {
        return true;
    }

    @Override
    public boolean isSibilingTraversalExpensive() {
        return false;
    }
}

