/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.internal.server;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.etypes.Annotation;
import org.eclipse.emf.cdo.etypes.ModelElement;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.FloatingBaseline;
import org.eclipse.emf.cdo.lm.LMPackage;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.reviews.Comment;
import org.eclipse.emf.cdo.lm.reviews.DeliveryReview;
import org.eclipse.emf.cdo.lm.reviews.DropReview;
import org.eclipse.emf.cdo.lm.reviews.Review;
import org.eclipse.emf.cdo.lm.reviews.ReviewStatus;
import org.eclipse.emf.cdo.lm.reviews.ReviewsPackage;
import org.eclipse.emf.cdo.lm.reviews.Topic;
import org.eclipse.emf.cdo.lm.reviews.TopicContainer;
import org.eclipse.emf.cdo.lm.reviews.impl.ReviewStatemachine;
import org.eclipse.emf.cdo.lm.reviews.internal.server.ServerReviewStatemachine;
import org.eclipse.emf.cdo.lm.reviews.internal.server.bundle.OM;
import org.eclipse.emf.cdo.lm.reviews.server.IReviewManager;
import org.eclipse.emf.cdo.lm.reviews.server.IReviewManagerEvent;
import org.eclipse.emf.cdo.lm.server.AbstractLifecycleManager;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.ISession;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.InternalStore;
import org.eclipse.emf.cdo.util.ObjectNotFoundException;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.lifecycle.IDeactivateable;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class ReviewManager
extends Lifecycle
implements IReviewManager,
LMPackage.Literals,
ReviewsPackage.Literals {
    public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.lm.reviews.server.reviewManagers";
    public static final String DEFAULT_TYPE = "default";
    private final ServerReviewStatemachine<DeliveryReview> deliveriesReviewStatemachine = new ServerReviewStatemachine(this, false);
    private final ServerReviewStatemachine<DropReview> dropsReviewStatemachine = new ServerReviewStatemachine(this, true);
    private AbstractLifecycleManager lifecycleManager;
    private final IListener lifecycleManagerListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof AbstractLifecycleManager.SystemCommitEvent) {
                AbstractLifecycleManager.SystemCommitEvent e = (AbstractLifecycleManager.SystemCommitEvent)event;
                ReviewManager.this.handleSystemCommitEvent(e);
            } else if (event instanceof AbstractLifecycleManager.ModuleCommitEvent) {
                AbstractLifecycleManager.ModuleCommitEvent e = (AbstractLifecycleManager.ModuleCommitEvent)event;
                ReviewManager.this.handleModuleCommitEvent(e);
            } else if (event instanceof AbstractLifecycleManager.NewBaselineEvent) {
                AbstractLifecycleManager.NewBaselineEvent e = (AbstractLifecycleManager.NewBaselineEvent)event;
                ReviewManager.this.handleNewBaselineEvent(e);
            }
        }
    };
    private final IDCounter reviewIDCounter = new IDCounter("org.eclipse.emf.cdo.lm.reviews.lastReviewID");
    private final IDCounter topicIDCounter = new IDCounter("org.eclipse.emf.cdo.lm.reviews.lastTopicID");
    private final IDCounter commentIDCounter = new IDCounter("org.eclipse.emf.cdo.lm.reviews.lastCommentID");
    private ExecutorService executorService;

    @Override
    public AbstractLifecycleManager getLifecycleManager() {
        return this.lifecycleManager;
    }

    public void setLifecycleManager(AbstractLifecycleManager lifecycleManager) {
        this.checkInactive();
        this.lifecycleManager = lifecycleManager;
    }

    public String toString() {
        InternalRepository systemRepository;
        Object str = super.toString();
        if (this.lifecycleManager != null && (systemRepository = this.lifecycleManager.getSystemRepository()) != null) {
            str = (String)str + "[systemRepository=" + systemRepository.getName() + "]";
        }
        return str;
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        CheckUtil.checkState((Object)this.lifecycleManager, (String)"lifecycleManager");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.executorService = ConcurrencyUtil.getExecutorService((IManagedContainer)this.lifecycleManager.getContainer());
        this.loadLastReviewID();
        this.lifecycleManager.addSystemCommitHandler(this::handleSystemCommit);
        this.lifecycleManager.addListener(this.lifecycleManagerListener);
    }

    protected void doDeactivate() throws Exception {
        this.lifecycleManager.removeListener(this.lifecycleManagerListener);
        this.lifecycleManager.removeSystemCommitHandler(this::handleSystemCommit);
        this.saveLastReviewID();
        this.executorService = null;
        super.doDeactivate();
    }

    protected void handleSystemCommit(IStoreAccessor.CommitContext commitContext) {
        String author = commitContext.getUserID();
        long timeStamp = commitContext.getBranchPoint().getTimeStamp();
        InternalCDORevision[] newObjects = commitContext.getNewObjects();
        int i = 0;
        while (i < newObjects.length) {
            InternalCDORevision revision = newObjects[i];
            EClass eClass = revision.getEClass();
            if (ReviewManager.isAuthorableClass(eClass)) {
                int index = i;
                int id = (eClass == TOPIC ? this.topicIDCounter : this.commentIDCounter).getNextID();
                commitContext.modify(modificationContext -> {
                    List list = modificationContext.getChangeSetData().getNewObjects();
                    InternalCDORevision element = (InternalCDORevision)list.get(index);
                    element.setValue((EStructuralFeature)AUTHORABLE__ID, (Object)id);
                    element.setValue((EStructuralFeature)AUTHORABLE__AUTHOR, (Object)author);
                    element.setValue((EStructuralFeature)AUTHORABLE__CREATION_TIME, (Object)timeStamp);
                    element.setValue((EStructuralFeature)AUTHORABLE__EDIT_TIME, null);
                });
            }
            ++i;
        }
    }

    protected void handleSystemCommitEvent(AbstractLifecycleManager.SystemCommitEvent systemCommitEvent) {
        IStoreAccessor.CommitContext commitContext = systemCommitEvent.getCommitContext();
        long timeStamp = commitContext.getBranchPoint().getTimeStamp();
        IListener[] listeners = this.getListeners();
        HashMap<CDOID, ReviewManagerEvent> events = listeners.length == 0 ? null : new HashMap<CDOID, ReviewManagerEvent>();
        ISession session = commitContext.getTransaction().getSession();
        CDOBranchPoint oldBranchPoint = CDOBranchUtil.adjustTime((CDOBranchPoint)commitContext.getBranchPoint(), (long)-1L);
        ViewSupplier oldViewSupplier = new ViewSupplier(() -> CDOServerUtil.openView((ISession)session, (CDOBranchPoint)oldBranchPoint));
        ViewSupplier newViewSupplier = new ViewSupplier(() -> CDOServerUtil.openView((IStoreAccessor.CommitContext)commitContext));
        if (events != null) {
            InternalCDORevision[] newObjects = commitContext.getNewObjects();
            int i = 0;
            while (i < newObjects.length) {
                InternalCDORevision newObject = newObjects[i];
                EClass eClass = newObject.getEClass();
                if (ReviewManager.isReviewClass(eClass)) {
                    CDOID reviewID = newObject.getID();
                    events.put(reviewID, new ReviewManagerEvent(this, IReviewManagerEvent.Type.ReviewCreated, reviewID, oldViewSupplier, newViewSupplier));
                }
                ++i;
            }
        }
        InternalCDORevisionDelta[] internalCDORevisionDeltaArray = commitContext.getDirtyObjectDeltas();
        int n = internalCDORevisionDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOID authorableID;
            InternalCDORevision reviewRevision;
            InternalCDORevisionDelta dirtyObjectDelta = internalCDORevisionDeltaArray[n2];
            EClass eClass = dirtyObjectDelta.getEClass();
            if (ReviewManager.isReviewClass(eClass)) {
                ReviewStatus newStatus;
                CDOID reviewID = dirtyObjectDelta.getID();
                if (events != null) {
                    ReviewManagerEvent event = events.computeIfAbsent(reviewID, k -> new ReviewManagerEvent(this, IReviewManagerEvent.Type.ReviewChanged, reviewID, oldViewSupplier, newViewSupplier));
                    event.changedFeatures.addAll(dirtyObjectDelta.getFeatureDeltaMap().keySet());
                }
                if ((newStatus = ReviewManager.getReviewStatus(dirtyObjectDelta)) == ReviewStatus.RESTORING) {
                    this.executorService.submit(() -> {
                        CDOView systemView = this.lifecycleManager.getSystem().cdoView();
                        systemView.waitForUpdate(timeStamp);
                        CDOObject reviewObject = systemView.getObject(reviewID);
                        if (reviewObject instanceof Review) {
                            Review review = (Review)reviewObject;
                            ServerReviewStatemachine<Review> reviewStatemachine = this.getReviewStatemachine(review);
                            reviewStatemachine.process(review, (Enum)ReviewStatemachine.ReviewEvent.Finish, null);
                        }
                    });
                }
            } else if (events != null && ReviewManager.isAuthorableClass(eClass) && (reviewRevision = ReviewManager.getReviewRevision(authorableID = dirtyObjectDelta.getID(), commitContext)) != null) {
                CDOID reviewID = reviewRevision.getID();
                ReviewManagerEvent event = events.computeIfAbsent(reviewID, k -> new ReviewManagerEvent(this, IReviewManagerEvent.Type.ReviewChanged, reviewID, oldViewSupplier, newViewSupplier));
                event.changedFeatures.addAll(dirtyObjectDelta.getFeatureDeltaMap().keySet());
            }
            ++n2;
        }
        if (events != null) {
            for (ReviewManagerEvent event : events.values()) {
                this.fireEvent(event, listeners);
            }
            newViewSupplier.deactivate();
            oldViewSupplier.deactivate();
        }
    }

    protected void handleModuleCommitEvent(AbstractLifecycleManager.ModuleCommitEvent event) {
        Map commitProperties = event.getCommitContext().getCommitProperties();
        String value = (String)commitProperties.get("org.eclipse.emf.cdo.lm.submitting");
        int submittingReviewID = value == null ? -1 : Integer.valueOf(value);
        FloatingBaseline baseline = event.getCommitBaseline();
        if (baseline instanceof Stream) {
            Stream stream = (Stream)baseline;
            stream.forEachBaseline(content -> {
                if (content instanceof DeliveryReview) {
                    DeliveryReview review = (DeliveryReview)content;
                    if (review.getId() == submittingReviewID) {
                        return;
                    }
                    this.deliveriesReviewStatemachine.process(review, (Enum)ReviewStatemachine.ReviewEvent.CommitInTarget, null);
                }
            });
        } else if (baseline instanceof Change) {
            Change change = (Change)baseline;
            ReviewManager.forEachAnnotationObject((ModelElement)change, true, DeliveryReview.class, review -> {
                if (review.getId() == submittingReviewID) {
                    return;
                }
                this.deliveriesReviewStatemachine.process(review, (Enum)ReviewStatemachine.ReviewEvent.CommitInSource, null);
            });
        }
    }

    protected void handleNewBaselineEvent(AbstractLifecycleManager.NewBaselineEvent event) {
        CDORevision baseline = event.getNewBaseline();
        EClass eClass = baseline.getEClass();
        if (ReviewManager.isReviewClass(eClass)) {
            int reviewID = this.reviewIDCounter.getNextID();
            CDOID cdoid = baseline.getID();
            IStoreAccessor.CommitContext commitContext = event.getCommitContext();
            commitContext.modify(context -> {
                for (CDOIDAndVersion cdoidAndVersion : context.getChangeSetData().getNewObjects()) {
                    if (cdoidAndVersion.getID() != cdoid) continue;
                    InternalCDORevision reviewRevision = (InternalCDORevision)cdoidAndVersion;
                    this.handleNewReview(commitContext, reviewRevision, reviewID);
                    break;
                }
            });
        }
    }

    protected void handleNewReview(IStoreAccessor.CommitContext commitContext, InternalCDORevision reviewRevision, int reviewID) {
        reviewRevision.set((EStructuralFeature)REVIEW__ID, 0, (Object)reviewID);
        if (reviewRevision.getEClass() == DELIVERY_REVIEW) {
            CDOID changeID = (CDOID)reviewRevision.data().get((EStructuralFeature)DELIVERY_REVIEW__SOURCE_CHANGE, 0);
            CDORevision changeRevision = commitContext.getRevision(changeID);
            String changeBranchPath = (String)changeRevision.data().get((EStructuralFeature)CHANGE__BRANCH, 0);
            CDOID streamID = (CDOID)reviewRevision.data().getContainerID();
            CDORevision streamRevision = commitContext.getRevision(streamID);
            String streamBranchPath = (String)streamRevision.data().get((EStructuralFeature)STREAM__MAINTENANCE_BRANCH, 0);
            if (streamBranchPath == null) {
                streamBranchPath = (String)streamRevision.data().get((EStructuralFeature)STREAM__DEVELOPMENT_BRANCH, 0);
            }
            CDOID moduleID = (CDOID)streamRevision.data().getContainerID();
            CDORevision moduleRevision = commitContext.getRevision(moduleID);
            String moduleName = (String)moduleRevision.data().get((EStructuralFeature)MODULE__NAME, 0);
            CDOSession moduleSession = this.lifecycleManager.getModuleSession(moduleName);
            CDOBranchManager branchManager = moduleSession.getBranchManager();
            CDOCommitInfoManager commitInfoManager = moduleSession.getCommitInfoManager();
            CDOBranch changeBranch = branchManager.getBranch(changeBranchPath);
            long lastChangeCommit = commitInfoManager.getLastCommitOfBranch(changeBranch, true);
            CDOBranch streamBranch = branchManager.getBranch(streamBranchPath);
            long lastStreamCommit = commitInfoManager.getLastCommitOfBranch(streamBranch, true);
            CDOBranch reviewBranch = streamBranch.createBranch("review-" + reviewID);
            reviewRevision.set((EStructuralFeature)DELIVERY_REVIEW__BRANCH, 0, (Object)reviewBranch.getPathName());
            reviewRevision.set((EStructuralFeature)DELIVERY_REVIEW__SOURCE_COMMIT, 0, (Object)lastChangeCommit);
            reviewRevision.set((EStructuralFeature)DELIVERY_REVIEW__TARGET_COMMIT, 0, (Object)lastStreamCommit);
        }
    }

    private boolean containsUnknownID(Collection<String> values) {
        for (String value : values) {
            if (!"unknown".equals(value)) continue;
            return true;
        }
        return false;
    }

    private void initTopicAndCommentIDs(TopicContainer container) {
        for (Comment comment : container.getComments()) {
            this.commentIDCounter.initID(comment.getId());
        }
        for (Topic topic : container.getTopics()) {
            this.topicIDCounter.initID(topic.getId());
            this.initTopicAndCommentIDs((TopicContainer)topic);
        }
    }

    private void loadLastReviewID() {
        HashSet<String> keys = new HashSet<String>();
        keys.add(this.reviewIDCounter.propertyKey);
        keys.add(this.topicIDCounter.propertyKey);
        keys.add(this.commentIDCounter.propertyKey);
        InternalStore store = this.lifecycleManager.getSystemRepository().getStore();
        Map properties = store.getPersistentProperties(keys);
        if (this.containsUnknownID(properties.values())) {
            OM.LOG.info("Restoring ID counters...");
            this.lifecycleManager.getSystem().forEachBaseline(baseline -> {
                if (baseline instanceof Review) {
                    Review review = (Review)baseline;
                    this.reviewIDCounter.initID(review.getId());
                    this.initTopicAndCommentIDs((TopicContainer)review);
                }
            });
        } else {
            this.reviewIDCounter.initID(properties);
            this.topicIDCounter.initID(properties);
            this.commentIDCounter.initID(properties);
        }
        for (String key : keys) {
            properties.put(key, "unknown");
        }
        store.setPersistentProperties(properties);
        OM.LOG.info(this.reviewIDCounter.toString());
        OM.LOG.info(this.topicIDCounter.toString());
        OM.LOG.info(this.commentIDCounter.toString());
    }

    private void saveLastReviewID() {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.reviewIDCounter.addToMap(properties);
        this.topicIDCounter.addToMap(properties);
        this.commentIDCounter.addToMap(properties);
        InternalStore store = this.lifecycleManager.getSystemRepository().getStore();
        store.setPersistentProperties(properties);
    }

    private <REVIEW extends Review> ServerReviewStatemachine<REVIEW> getReviewStatemachine(REVIEW review) {
        if (review instanceof DeliveryReview) {
            return this.deliveriesReviewStatemachine;
        }
        if (review instanceof DropReview) {
            return this.dropsReviewStatemachine;
        }
        return null;
    }

    private static ReviewStatus getReviewStatus(InternalCDORevisionDelta revisionDelta) {
        CDOSetFeatureDelta statusDelta = (CDOSetFeatureDelta)revisionDelta.getFeatureDelta((EStructuralFeature)REVIEW__STATUS);
        if (statusDelta != null) {
            int value = (Integer)statusDelta.getValue();
            try {
                return ReviewStatus.get((int)value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static InternalCDORevision getReviewRevision(CDOID id, IStoreAccessor.CommitContext commitContext) {
        InternalCDORevision revision = (InternalCDORevision)commitContext.getRevision(id);
        if (revision != null) {
            return ReviewManager.getReviewRevision(revision, (CDORevisionProvider)commitContext);
        }
        return null;
    }

    private static InternalCDORevision getReviewRevision(InternalCDORevision revision, CDORevisionProvider revisionProvider) {
        InternalCDORevision container;
        CDOID containerID;
        EClass eClass = revision.getEClass();
        if (ReviewManager.isReviewClass(eClass)) {
            return revision;
        }
        if (ReviewManager.isAuthorableClass(eClass) && !CDOIDUtil.isNull((CDOID)(containerID = (CDOID)revision.getContainerID())) && (container = (InternalCDORevision)revisionProvider.getRevision(containerID)) != null) {
            return ReviewManager.getReviewRevision(container, revisionProvider);
        }
        return null;
    }

    private static boolean isReviewClass(EClass eClass) {
        return eClass == DELIVERY_REVIEW || eClass == DROP_REVIEW;
    }

    private static boolean isAuthorableClass(EClass eClass) {
        return eClass == TOPIC || eClass == COMMENT;
    }

    private static <T extends EObject> void forEachAnnotationObject(ModelElement modelElement, boolean referenced, Class<T> type, Consumer<T> consumer) {
        Annotation annotation = ReviewsPackage.getAnnotation((ModelElement)modelElement, (boolean)false);
        if (annotation != null) {
            EList objects = referenced ? annotation.getReferences() : annotation.getContents();
            for (EObject object : objects) {
                if (!type.isInstance(object)) continue;
                consumer.accept((EObject)type.cast(object));
            }
        }
    }

    private static final class IDCounter {
        private static final String UNKNOWN = "unknown";
        private final String propertyKey;
        private int lastID;

        public IDCounter(String propertyKey) {
            this.propertyKey = propertyKey;
        }

        public synchronized int getNextID() {
            return ++this.lastID;
        }

        public void addToMap(Map<String, String> properties) {
            properties.put(this.propertyKey, Integer.toString(this.lastID));
        }

        public void initID(int id) {
            this.lastID = Math.max(this.lastID, id);
        }

        public void initID(Map<String, String> properties) {
            String property = properties.get(this.propertyKey);
            if (property != null) {
                this.lastID = Integer.parseInt(property);
            }
        }

        public String toString() {
            return this.propertyKey + " = " + this.lastID;
        }
    }

    private static final class ReviewManagerEvent
    extends Event
    implements IReviewManagerEvent {
        private static final long serialVersionUID = 1L;
        private final IReviewManagerEvent.Type type;
        private final CDOID cdoid;
        private final Supplier<CDOView> oldViewSupplier;
        private final Supplier<CDOView> newViewSupplier;
        private final Set<EStructuralFeature> changedFeatures = new HashSet<EStructuralFeature>();

        public ReviewManagerEvent(IReviewManager notifier, IReviewManagerEvent.Type type, CDOID cdoid, Supplier<CDOView> oldViewSupplier, Supplier<CDOView> newViewSupplier) {
            super((INotifier)notifier);
            this.type = type;
            this.cdoid = cdoid;
            this.oldViewSupplier = oldViewSupplier;
            this.newViewSupplier = newViewSupplier;
        }

        @Override
        public IReviewManager getSource() {
            return (IReviewManager)super.getSource();
        }

        @Override
        public IReviewManagerEvent.Type getType() {
            return this.type;
        }

        @Override
        public CDOID getCDOID() {
            return this.cdoid;
        }

        @Override
        public Review getOldReview() {
            if (this.type == IReviewManagerEvent.Type.ReviewCreated || this.oldViewSupplier == null) {
                return null;
            }
            CDOView view = this.oldViewSupplier.get();
            try {
                return (Review)view.getObject(this.cdoid);
            }
            catch (ObjectNotFoundException ex) {
                return null;
            }
        }

        @Override
        public Review getNewReview() {
            if (this.type == IReviewManagerEvent.Type.ReviewDeleted || this.newViewSupplier == null) {
                return null;
            }
            CDOView view = this.newViewSupplier.get();
            try {
                return (Review)view.getObject(this.cdoid);
            }
            catch (ObjectNotFoundException ex) {
                return null;
            }
        }

        @Override
        public Set<EStructuralFeature> getChangedFeatures() {
            return Collections.unmodifiableSet(this.changedFeatures);
        }

        protected String formatAdditionalParameters() {
            return "type=" + String.valueOf((Object)this.type) + ", cdoid=" + String.valueOf(this.cdoid) + ", changedFeatures=" + String.valueOf(this.changedFeatures.stream().map(ReviewManagerEvent::formatFeatureName).collect(Collectors.toList()));
        }

        private static String formatFeatureName(EStructuralFeature feature) {
            return feature.getEContainingClass().getName() + "." + feature.getName();
        }
    }

    public static final class ReviewManagerRegistry
    implements IReviewManager.Registry {
        public static final ReviewManagerRegistry INSTANCE = new ReviewManagerRegistry();
        private final Map<InternalRepository, IReviewManager> reviewManagers = Collections.synchronizedMap(new HashMap());

        private ReviewManagerRegistry() {
        }

        @Override
        public IReviewManager getReviewManager(IRepository repository) {
            return this.reviewManagers.get(repository);
        }

        public IReviewManager removeReviewManager(InternalRepository repository) {
            return this.reviewManagers.remove(repository);
        }

        public void addReviewManager(InternalRepository repository, IReviewManager reviewManager) {
            this.reviewManagers.put(repository, reviewManager);
        }
    }

    private static final class ViewSupplier
    implements Supplier<CDOView>,
    IDeactivateable {
        private final Supplier<CDOView> viewOpener;
        private CDOView view;

        public ViewSupplier(Supplier<CDOView> viewOpener) {
            this.viewOpener = viewOpener;
        }

        @Override
        public synchronized CDOView get() {
            if (this.view == null) {
                this.view = this.viewOpener.get();
            }
            return this.view;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exception deactivate() {
            CDOView v;
            ViewSupplier viewSupplier = this;
            synchronized (viewSupplier) {
                v = this.view;
                this.view = null;
            }
            if (v != null) {
                return LifecycleUtil.deactivate((Object)v);
            }
            return null;
        }
    }
}

