/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.util;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.model.CDOModelUtil;
import org.eclipse.emf.cdo.common.model.CDOType;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionCrawler;
import org.eclipse.emf.cdo.common.revision.CDORevisionFactory;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOClassInfo;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;

public final class EObjectCrawler
extends Lifecycle {
    private final ModelScope scope;
    private final Map<CDOID, CDORevision> revisions = new HashMap<CDOID, CDORevision>();
    private final CDORevisionFactory revisionFactory;
    private final CDORevisionCrawler revisionCrawler = new CDORevisionCrawler().revisionProvider(this::getRevision);

    private EObjectCrawler(ModelScope scope, CDORevisionFactory revisionFactory) {
        this.scope = Objects.requireNonNull(scope);
        this.revisionFactory = (CDORevisionFactory)ObjectUtil.requireNonNullElse((Object)revisionFactory, (Object)CDORevisionFactory.DEFAULT);
    }

    public CDORevisionCrawler.Handler handler() {
        return this.revisionCrawler.handler();
    }

    public EObjectCrawler handler(CDORevisionCrawler.Handler handler) {
        this.checkInactive();
        this.revisionCrawler.handler(handler);
        return this;
    }

    public CDORevisionCrawler.ContainmentProxyStrategy containmentProxyStrategy() {
        return this.revisionCrawler.containmentProxyStrategy();
    }

    public EObjectCrawler containmentProxyStrategy(CDORevisionCrawler.ContainmentProxyStrategy containmentProxyStrategy) {
        this.checkInactive();
        this.revisionCrawler.containmentProxyStrategy(containmentProxyStrategy);
        return this;
    }

    public CDORevisionCrawler.FeatureStrategy featureStrategy() {
        return this.revisionCrawler.featureStrategy();
    }

    public EObjectCrawler featureStrategy(CDORevisionCrawler.FeatureStrategy featureStrategy) {
        this.checkInactive();
        this.revisionCrawler.featureStrategy(featureStrategy);
        return this;
    }

    public long objectCount() {
        return this.revisionCrawler.revisionCount();
    }

    public EObjectCrawler addObject(EObject object) {
        this.checkActive();
        CDORevision revision = this.getRevision(object);
        if (object == null) {
            throw new IllegalStateException("No revision for object: " + object);
        }
        this.revisionCrawler.addRevision(revision);
        return this;
    }

    public EObjectCrawler begin() {
        this.activate();
        return this;
    }

    public EObjectCrawler finish() {
        this.deactivate();
        return this;
    }

    protected void doActivate() throws Exception {
        this.revisionCrawler.begin();
    }

    protected void doDeactivate() throws Exception {
        this.revisionCrawler.finish();
    }

    private CDORevision getRevision(EObject object) {
        CDOID id = (CDOID)this.scope.ids.get(object);
        if (id != null) {
            return this.getRevision(id);
        }
        throw new IllegalStateException("No revision for object: " + object);
    }

    private CDORevision getRevision(CDOID id) {
        return this.revisions.computeIfAbsent(id, this::createRevision);
    }

    private CDORevision createRevision(CDOID id) {
        InternalEObject object = (InternalEObject)this.scope.objects.get(id);
        if (object != null) {
            InternalCDORevision revision = (InternalCDORevision)this.revisionFactory.createRevision(object.eClass());
            revision.setID(id);
            InternalCDOClassInfo classInfo = revision.getClassInfo();
            EStructuralFeature[] allPersistentFeatures = classInfo.getAllPersistentFeatures();
            int i = 0;
            int length = allPersistentFeatures.length;
            while (i < length) {
                EStructuralFeature feature = allPersistentFeatures[i];
                Object setting = object.eGet(feature);
                this.featureToRevision(object, revision, feature, setting);
                ++i;
            }
            revision.setUnchunked();
            return revision;
        }
        throw new IllegalStateException("No revision for id: " + id);
    }

    private void featureToRevision(InternalEObject object, InternalCDORevision revision, EStructuralFeature feature, Object setting) {
        if (feature.isMany()) {
            if (setting != null) {
                EList instanceList = (EList)setting;
                int size = instanceList.size();
                if (feature.isUnsettable() ? !object.eIsSet(feature) : size == 0) {
                    return;
                }
                CDOList revisionList = revision.getOrCreateList(feature, size);
                for (Object value : instanceList) {
                    Object cdoValue = this.convertToCDO(feature, value);
                    revisionList.add(cdoValue);
                }
            }
        } else {
            Object cdoValue = this.convertToCDO(feature, setting);
            revision.set(feature, 0, cdoValue);
        }
    }

    private Object convertToCDO(EStructuralFeature feature, Object value) {
        if (feature instanceof EReference) {
            if (value instanceof EObject) {
                CDOID id = (CDOID)this.scope.ids.get(value);
                if (id == null) {
                    throw new IllegalStateException("No id for object: " + value);
                }
                value = id;
            }
        } else {
            CDOType type = CDOModelUtil.getType(feature.getEType());
            if (type != null) {
                value = type.convertToCDO(feature.getEType(), value);
            }
        }
        return value;
    }

    /* synthetic */ EObjectCrawler(ModelScope modelScope, CDORevisionFactory cDORevisionFactory, EObjectCrawler eObjectCrawler) {
        this(modelScope, cDORevisionFactory);
    }

    public static final class ModelScope {
        private final Map<EObject, CDOID> ids = new HashMap<EObject, CDOID>();
        private final Map<CDOID, EObject> objects = new HashMap<CDOID, EObject>();
        private long lastID;
        private boolean frozen;

        public ModelScope registerObject(EObject object) {
            if (this.frozen) {
                throw new IllegalStateException("Model scope is frozen");
            }
            if (object != null) {
                this.ids.computeIfAbsent(object, key -> {
                    CDOID id = CDOIDUtil.createLong(++this.lastID);
                    this.objects.put(id, object);
                    return id;
                });
            }
            return this;
        }

        public ModelScope registerObject(EObject object, boolean recursive) {
            if (object != null) {
                this.registerObject(object);
                if (recursive) {
                    TreeIterator it = object.eAllContents();
                    while (it.hasNext()) {
                        EObject child = (EObject)it.next();
                        this.registerObject(child);
                    }
                }
            }
            return this;
        }

        public EObjectCrawler createCrawler() {
            return this.createCrawler(null);
        }

        public EObjectCrawler createCrawler(CDORevisionFactory revisionFactory) {
            this.frozen = true;
            return new EObjectCrawler(this, revisionFactory, null);
        }
    }
}

