/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.xotcl.internal.core.parser;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.FieldDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.ITclCommandDetector;
import org.eclipse.dltk.tcl.core.ITclCommandDetectorExtension;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.xotcl.core.XOTclParseUtil;
import org.eclipse.dltk.xotcl.core.ast.xotcl.XOTclObjectDeclaration;
import org.eclipse.dltk.xotcl.internal.core.XOTclKeywords;
import org.eclipse.dltk.xotcl.internal.core.parser.XOTclMixinUtils;
import org.eclipse.dltk.xotcl.internal.core.search.mixin.model.XOTclClass;

public class XOTclCommandDetector
implements ITclCommandDetector,
ITclCommandDetectorExtension {
    public static boolean INTERPRET_CLASS_UNKNOWN_AS_CREATE = true;
    public static boolean INTERPRET_OBJECT_UNKNOWN_AS_CREATE = true;
    private boolean runtimeModel = false;
    private Set names = new HashSet();

    public ITclCommandDetector.CommandInfo detectCommand(TclStatement statement, ModuleDeclaration module, ASTNode parent) {
        if (statement.getCount() == 0) {
            return null;
        }
        Expression commandName = statement.getAt(0);
        if (commandName instanceof SimpleReference) {
            String value = ((SimpleReference)commandName).getName();
            if (value.equals("Class") || value.equals("::xotcl::Class") || value.equals("xotcl::Class")) {
                return this.checkClass(statement, module, parent);
            }
            if (value.equals("Object") || value.equals("::xotcl::Object") || value.equals("xotcl::Object")) {
                return this.checkObject(statement, module, parent);
            }
            return this.checkInstanceOperations(module, parent, statement);
        }
        return null;
    }

    private ITclCommandDetector.CommandInfo checkInstanceOperations(ModuleDeclaration module, ASTNode parent, TclStatement statement) {
        FieldDeclaration variable;
        Expression commandName = statement.getAt(0);
        if (!(commandName instanceof SimpleReference)) {
            return null;
        }
        String commandNameValue = ((SimpleReference)commandName).getName();
        String[] names = null;
        names = TclParseUtil.tclSplit((String)commandNameValue);
        boolean found = false;
        int i = 0;
        while (i < names.length) {
            if (this.names.contains(names[i])) {
                found = true;
                break;
            }
            ++i;
        }
        if (statement.getCount() == 1) {
            return null;
        }
        Expression arg = statement.getAt(1);
        if (found) {
            TypeDeclaration type = TclParseUtil.findXOTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)parent, (String)commandNameValue);
            if (type != null && arg instanceof SimpleReference) {
                return this.check(type, (SimpleReference)arg);
            }
            XOTclObjectDeclaration decl = XOTclParseUtil.findXOTclObjectInstanceFrom(module, parent, commandNameValue);
            if (decl != null) {
                String value;
                if (arg instanceof SimpleReference && (value = ((SimpleReference)arg).getName()).equals("proc")) {
                    return new ITclCommandDetector.CommandInfo("#Class#proc", (Object)decl);
                }
                return new ITclCommandDetector.CommandInfo("#Class#$ProcCall", (Object)type);
            }
        }
        if (found && (variable = XOTclParseUtil.findXOTclInstanceVariableDeclarationFrom(module, parent, commandNameValue)) != null) {
            return new ITclCommandDetector.CommandInfo("#Class#$MethodCall", (Object)variable);
        }
        if (statement.getCount() < 3) {
            return null;
        }
        if (!(arg instanceof SimpleReference)) {
            return null;
        }
        String argumentValue = ((SimpleReference)arg).getName();
        if (commandNameValue.length() >= 3) {
            if (commandNameValue.startsWith("::")) {
                commandNameValue = commandNameValue.substring(2);
            }
            boolean isUpper = Character.isUpperCase(commandNameValue.charAt(0));
            if ((commandNameValue.indexOf("::") > 0 || isUpper) && argumentValue.equals("create")) {
                XOTclGlobalClassParameter param = new XOTclGlobalClassParameter(commandNameValue);
                return new ITclCommandDetector.CommandInfo("#Class#$newInstance", (Object)param);
            }
        }
        return null;
    }

    private ITclCommandDetector.CommandInfo check(TypeDeclaration type, SimpleReference arg) {
        if ((type.getModifiers() & 0x100000) == 0) {
            return null;
        }
        String value = arg.getName();
        if (!value.equals("create")) {
            ITclCommandDetector.CommandInfo info = this.checkCommands(value, type);
            if (info != null) {
                return info;
            }
        } else {
            return new ITclCommandDetector.CommandInfo("#Class#$newInstance", (Object)type);
        }
        return new ITclCommandDetector.CommandInfo("#Class#$ProcCall", (Object)type);
    }

    private ITclCommandDetector.CommandInfo checkCommands(String value, Object decl) {
        ITclCommandDetector.CommandInfo info = this.checkClassOperator(decl, value, XOTclKeywords.XOTclCommandClassArgs, "#Class#");
        if (info != null) {
            return info;
        }
        info = this.checkClassOperator(decl, value, XOTclKeywords.XOTclCommandObjectArgs, "#Object#");
        if (info != null) {
            return info;
        }
        return null;
    }

    private ITclCommandDetector.CommandInfo checkClassOperator(Object type, String value, String[] commands, String prefix) {
        int q = 0;
        while (q < commands.length) {
            if (value.equals(commands[q])) {
                return new ITclCommandDetector.CommandInfo(String.valueOf(prefix) + value, type);
            }
            ++q;
        }
        return null;
    }

    private ITclCommandDetector.CommandInfo checkClass(TclStatement statement, ModuleDeclaration module, ASTNode parent) {
        Expression arg = statement.getAt(1);
        if (arg instanceof SimpleReference) {
            String value = ((SimpleReference)arg).getName();
            TypeDeclaration type = TclParseUtil.findXOTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)parent, (String)"Class");
            int i = 0;
            while (i < XOTclKeywords.XOTclCommandClassArgs.length) {
                if (value.equals(XOTclKeywords.XOTclCommandClassArgs[i])) {
                    return new ITclCommandDetector.CommandInfo("#Class#" + value, (Object)type);
                }
                ++i;
            }
            ITclCommandDetector.CommandInfo info = this.checkCreateType(statement, parent, arg, value);
            if (info != null) {
                return info;
            }
            if (INTERPRET_CLASS_UNKNOWN_AS_CREATE) {
                return new ITclCommandDetector.CommandInfo("#Class#create", null);
            }
            return null;
        }
        return null;
    }

    private ITclCommandDetector.CommandInfo checkObject(TclStatement statement, ModuleDeclaration module, ASTNode parent) {
        Expression arg = statement.getAt(1);
        if (arg instanceof SimpleReference) {
            String value = ((SimpleReference)arg).getName();
            TypeDeclaration type = TclParseUtil.findXOTclTypeDeclarationFrom((ModuleDeclaration)module, (ASTNode)parent, (String)"Object");
            int i = 0;
            while (i < XOTclKeywords.XOTclCommandObjectArgs.length) {
                if (value.equals(XOTclKeywords.XOTclCommandObjectArgs[i])) {
                    return new ITclCommandDetector.CommandInfo("#Object#" + value, (Object)type);
                }
                ++i;
            }
            ITclCommandDetector.CommandInfo info = this.checkCreateType(statement, parent, arg, value);
            if (info != null) {
                return info;
            }
            if (INTERPRET_OBJECT_UNKNOWN_AS_CREATE) {
                return new ITclCommandDetector.CommandInfo("#Object#create", null);
            }
            return null;
        }
        return null;
    }

    private ITclCommandDetector.CommandInfo checkCreateType(TclStatement statement, ASTNode parent, Expression arg, String value) {
        if (value.equals("instproc") || value.equals("proc") || value.equals("set")) {
            String name = TclParseUtil.getNameFromNode((ASTNode)statement.getAt(0));
            TypeDeclaration decl = this.createTypeAdd(statement, parent, statement.getAt(0), name);
            ITclCommandDetector.CommandInfo info = this.checkCommands(value, decl);
            if (info != null) {
                return info;
            }
        }
        return null;
    }

    private TypeDeclaration createTypeAdd(TclStatement statement, ASTNode parent, Expression arg, String value) {
        TypeDeclaration decl = new TypeDeclaration(value, arg.sourceStart(), arg.sourceEnd(), arg.sourceStart(), arg.sourceEnd());
        TclParseUtil.addToDeclaration((ASTNode)parent, (ASTNode)decl);
        return decl;
    }

    public void setBuildRuntimeModelFlag(boolean value) {
        this.runtimeModel = value;
    }

    public void processASTNode(ASTNode node) {
        FieldDeclaration decl;
        String name = null;
        if (node instanceof FieldDeclaration) {
            decl = (FieldDeclaration)node;
            name = decl.getName();
        } else if (node instanceof TypeDeclaration) {
            decl = (TypeDeclaration)node;
            name = decl.getName();
        }
        if (name != null) {
            String[] names = null;
            names = name.startsWith("::") ? name.substring(2).split("::") : name.split("::");
            int i = 0;
            while (i < names.length) {
                this.names.add(names[i]);
                ++i;
            }
        }
    }

    public static class XOTclGlobalClassParameter {
        private String name;

        public XOTclGlobalClassParameter(String name) {
            this.name = name;
        }

        public IModelElement resolveElement() {
            XOTclClass e = XOTclMixinUtils.findMixinElement(this.name, null);
            if (e != null) {
                return e.getModelElement();
            }
            return null;
        }

        public String getClassName() {
            return this.name;
        }
    }
}

