/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.plan.internal.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.plan.internal.util.ILogger;
import org.eclipse.datatools.sqltools.plan.internal.util.Messages;

public class StatusLogger
implements ILogger {
    private ILog _log;
    private ResourceBundle _rb;
    private String _pluginId;

    public StatusLogger(ILog log, String pluginId, ResourceBundle bundle) {
        this._log = log;
        this._pluginId = pluginId;
        this._rb = bundle;
    }

    @Override
    public void fatal(Object message) {
        this.fatal(message, null);
    }

    @Override
    public void fatal(Object message, Throwable tt) {
        Status status = new Status(4, this._pluginId, 0, (String)message, tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void fatal(String key) {
        Status status = new Status(4, this._pluginId, 0, this.getResourceBundleString(key), null);
        this._log.log((IStatus)status);
    }

    @Override
    public void fatal(String key, Throwable tt) {
        Status status = new Status(4, this._pluginId, 0, this.getResourceBundleString(key), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void fatal(String key, Object arg0) {
        this.error(key, arg0, null);
    }

    @Override
    public void fatal(String key, Object arg0, Throwable tt) {
        Object[] args = new Object[]{arg0};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(4, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void fatal(String key, Object arg0, Object arg1) {
        this.error(key, arg0, arg1, null);
    }

    @Override
    public void fatal(String key, Object arg0, Object arg1, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(4, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void fatal(String key, Object arg0, Object arg1, Object arg2) {
        this.error(key, arg0, arg1, arg2, null);
    }

    @Override
    public void fatal(String key, Object arg0, Object arg1, Object arg2, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(4, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void fatal(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.error(key, arg0, arg1, arg2, arg3, null);
    }

    @Override
    public void fatal(String key, Object arg0, Object arg1, Object arg2, Object arg3, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(4, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void fatal(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        this.error(key, arg0, arg1, arg2, arg3, arg4, null);
    }

    @Override
    public void fatal(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(4, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void fatal(String key, Object[] args) {
        this.error(key, args, (Throwable)null);
    }

    @Override
    public void fatal(String key, Object[] args, Throwable tt) {
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(4, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void error(Object message) {
        this.fatal(message, null);
    }

    @Override
    public void error(Object message, Throwable tt) {
        Status status = new Status(4, this._pluginId, 0, (String)message, tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void error(String key) {
        Status status = new Status(4, this._pluginId, 0, this.getResourceBundleString(key), null);
        this._log.log((IStatus)status);
    }

    @Override
    public void error(String key, Throwable tt) {
        Status status = new Status(4, this._pluginId, 0, this.getResourceBundleString(key), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void error(String key, Object arg0) {
        this.error(key, arg0, null);
    }

    @Override
    public void error(String key, Object arg0, Throwable tt) {
        Object[] args = new Object[]{arg0};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(4, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void error(String key, Object arg0, Object arg1) {
        this.error(key, arg0, arg1, null);
    }

    @Override
    public void error(String key, Object arg0, Object arg1, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(4, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void error(String key, Object arg0, Object arg1, Object arg2) {
        this.error(key, arg0, arg1, arg2, null);
    }

    @Override
    public void error(String key, Object arg0, Object arg1, Object arg2, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(4, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void error(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.error(key, arg0, arg1, arg2, arg3, null);
    }

    @Override
    public void error(String key, Object arg0, Object arg1, Object arg2, Object arg3, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(4, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void error(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        this.error(key, arg0, arg1, arg2, arg3, arg4, null);
    }

    @Override
    public void error(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(4, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void error(String key, Object[] args) {
        this.error(key, args, (Throwable)null);
    }

    @Override
    public void error(String key, Object[] args, Throwable tt) {
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(4, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void warn(Object message) {
        this.fatal(message, null);
    }

    @Override
    public void warn(Object message, Throwable tt) {
        Status status = new Status(2, this._pluginId, 0, (String)message, tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void warn(String key) {
        Status status = new Status(2, this._pluginId, 0, this.getResourceBundleString(key), null);
        this._log.log((IStatus)status);
    }

    @Override
    public void warn(String key, Throwable tt) {
        Status status = new Status(2, this._pluginId, 0, this.getResourceBundleString(key), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void warn(String key, Object arg0) {
        this.warn(key, arg0, null);
    }

    @Override
    public void warn(String key, Object arg0, Throwable tt) {
        Object[] args = new Object[]{arg0};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(2, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void warn(String key, Object arg0, Object arg1) {
        this.warn(key, arg0, arg1, null);
    }

    @Override
    public void warn(String key, Object arg0, Object arg1, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(2, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void warn(String key, Object arg0, Object arg1, Object arg2) {
        this.warn(key, arg0, arg1, arg2, null);
    }

    @Override
    public void warn(String key, Object arg0, Object arg1, Object arg2, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(2, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void warn(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.warn(key, arg0, arg1, arg2, arg3, null);
    }

    @Override
    public void warn(String key, Object arg0, Object arg1, Object arg2, Object arg3, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(2, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void warn(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        this.warn(key, arg0, arg1, arg2, arg3, arg4, null);
    }

    @Override
    public void warn(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(2, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void warn(String key, Object[] args) {
        this.warn(key, args, (Throwable)null);
    }

    @Override
    public void warn(String key, Object[] args, Throwable tt) {
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(2, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void info(Object message) {
        this.fatal(message, null);
    }

    @Override
    public void info(Object message, Throwable tt) {
        Status status = new Status(1, this._pluginId, 0, (String)message, tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void info(String key) {
        Status status = new Status(1, this._pluginId, 0, this.getResourceBundleString(key), null);
        this._log.log((IStatus)status);
    }

    @Override
    public void info(String key, Throwable tt) {
        Status status = new Status(1, this._pluginId, 0, this.getResourceBundleString(key), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void info(String key, Object arg0) {
        this.info(key, arg0, null);
    }

    @Override
    public void info(String key, Object arg0, Throwable tt) {
        Object[] args = new Object[]{arg0};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(1, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void info(String key, Object arg0, Object arg1) {
        this.info(key, arg0, arg1, null);
    }

    @Override
    public void info(String key, Object arg0, Object arg1, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(1, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void info(String key, Object arg0, Object arg1, Object arg2) {
        this.info(key, arg0, arg1, arg2, null);
    }

    @Override
    public void info(String key, Object arg0, Object arg1, Object arg2, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(1, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void info(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.info(key, arg0, arg1, arg2, arg3, null);
    }

    @Override
    public void info(String key, Object arg0, Object arg1, Object arg2, Object arg3, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(1, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void info(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        this.info(key, arg0, arg1, arg2, arg3, arg4, null);
    }

    @Override
    public void info(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(1, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void info(String key, Object[] args) {
        this.info(key, args, (Throwable)null);
    }

    @Override
    public void info(String key, Object[] args, Throwable tt) {
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(1, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void debug(Object message) {
        this.fatal(message, null);
    }

    @Override
    public void debug(Object message, Throwable tt) {
        Status status = new Status(1, this._pluginId, 0, (String)message, tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void debug(String key) {
        Status status = new Status(1, this._pluginId, 0, this.getResourceBundleString(key), null);
        this._log.log((IStatus)status);
    }

    @Override
    public void debug(String key, Throwable tt) {
        Status status = new Status(1, this._pluginId, 0, this.getResourceBundleString(key), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void debug(String key, Object arg0) {
        this.debug(key, arg0, null);
    }

    @Override
    public void debug(String key, Object arg0, Throwable tt) {
        Object[] args = new Object[]{arg0};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(1, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void debug(String key, Object arg0, Object arg1) {
        this.debug(key, arg0, arg1, null);
    }

    @Override
    public void debug(String key, Object arg0, Object arg1, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(1, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void debug(String key, Object arg0, Object arg1, Object arg2) {
        this.debug(key, arg0, arg1, arg2, null);
    }

    @Override
    public void debug(String key, Object arg0, Object arg1, Object arg2, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(1, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void debug(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        this.debug(key, arg0, arg1, arg2, arg3, null);
    }

    @Override
    public void debug(String key, Object arg0, Object arg1, Object arg2, Object arg3, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(1, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void debug(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        this.debug(key, arg0, arg1, arg2, arg3, arg4, null);
    }

    @Override
    public void debug(String key, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4, Throwable tt) {
        Object[] args = new Object[]{arg0, arg1, arg2, arg3, arg4};
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(1, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void debug(String key, Object[] args) {
        this.debug(key, args, (Throwable)null);
    }

    @Override
    public void debug(String key, Object[] args, Throwable tt) {
        MessageFormat formatter = new MessageFormat(this.getResourceBundleString(key));
        Status status = new Status(1, this._pluginId, 0, formatter.format(args), tt);
        this._log.log((IStatus)status);
    }

    @Override
    public void debugStr(String str) {
        this.debug((Object)str);
    }

    protected String getResourceBundleString(String key) {
        if (this._rb == null) {
            Status status = new Status(4, this._pluginId, 0, Messages.StatusLogger_no_bundle, null);
            this._log.log((IStatus)status);
            return String.valueOf(key) + Messages.StatusLogger_possible_args;
        }
        try {
            return this._rb.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            Status status = new Status(4, this._pluginId, 0, String.valueOf(Messages.StatusLogger_no_bundle) + key + "\".", null);
            this._log.log((IStatus)status);
            return String.valueOf(key) + Messages.StatusLogger_possible_args;
        }
    }
}

