/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.common.inject;

import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TargetType {
    private final Type type;
    private final String name;

    private TargetType(Type type, String name) {
        this.type = Objects.requireNonNull(type);
        this.name = Objects.requireNonNull(name);
        assert (type instanceof Class || type instanceof ParameterizedType);
    }

    public Class<?> getType() {
        if (this.type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)this.type).getRawType();
        }
        return (Class)this.type;
    }

    public Type getGenericType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public List<Type> getGenericParameterizedTypes() {
        if (this.type instanceof ParameterizedType) {
            return Arrays.asList(((ParameterizedType)this.type).getActualTypeArguments());
        }
        return Collections.emptyList();
    }

    public boolean hasParameterizedTypes() {
        return this.type instanceof ParameterizedType;
    }

    public Optional<Type> getFirstGenericTypes() {
        if (this.type instanceof ParameterizedType) {
            return Optional.of(((ParameterizedType)this.type).getActualTypeArguments()[0]);
        }
        return Optional.empty();
    }

    public static TargetType of(Field field) {
        return new TargetType(field.getGenericType(), field.getName());
    }

    public static TargetType of(Parameter parameter) {
        return new TargetType(parameter.getParameterizedType(), parameter.getName());
    }

    @Deprecated
    public static TargetType of(Type type, ParameterizedType parameterizedType) {
        assert (type == parameterizedType.getRawType());
        return new TargetType(parameterizedType, "<unknown>");
    }

    public boolean matches(Class<?> compareType) {
        return Objects.equals(this.getType(), compareType);
    }

    public boolean matches(Class<?> compareType, List<Type> compareGenericTypes) {
        return this.matches(compareType) && Objects.equals(this.getGenericParameterizedTypes(), compareGenericTypes);
    }

    public boolean matches(Class<?> compareType, Type ... compareGenericType) {
        return this.matches(compareType, Arrays.asList(compareGenericType));
    }

    public String toString() {
        return this.name + " " + this.type;
    }
}

