/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.transport.socket;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import org.eclipse.wst.jsdt.debug.transport.Connection;
import org.eclipse.wst.jsdt.debug.transport.packet.Packet;

public abstract class SocketConnection
implements Connection {
    private Writer writer;
    private Reader reader;
    private Socket socket;

    public SocketConnection(Socket socket) throws IOException {
        if (socket == null) {
            throw new IllegalArgumentException("You cannot create a new SocketConnection on a null Socket");
        }
        this.socket = socket;
        this.writer = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
        this.reader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
    }

    @Override
    public boolean isOpen() {
        return !this.socket.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    public Writer getWriter() {
        return this.writer;
    }

    @Override
    public abstract void writePacket(Packet var1) throws IOException;

    public Reader getReader() {
        return this.reader;
    }

    @Override
    public abstract Packet readPacket() throws IOException;
}

